/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.diagram.G2DUtils;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.PlainElementPropertySetter;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ElementPropertySetter
extends PlainElementPropertySetter {
    private static final long serialVersionUID = 712071316674596405L;
    public static final ElementPropertySetter INSTANCE = new ElementPropertySetter(ElementHints.KEY_SG_NODE);

    public ElementPropertySetter(IHintContext.Key key) {
        super(key);
    }

    public void loadProperties(IElement element, Resource r, ReadGraph g) {
        ElementHints.Properties properties = new ElementHints.Properties();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        try {
            for (Resource predicate : g.getPredicates(r)) {
                if (!g.isSubrelationOf(predicate, L0.HasProperty)) continue;
                try {
                    String name = (String)g.adapt(predicate, String.class);
                    Resource o = g.getPossibleObject(r, predicate);
                    if (o == null) continue;
                    Object val = G2DUtils.getObject(g, o);
                    properties.put((Object)name, val);
                }
                catch (AdaptionException e) {
                    e.printStackTrace();
                }
                catch (ValidationException e) {
                    e.printStackTrace();
                }
                catch (NoSingleResultException e) {
                    e.printStackTrace();
                }
                catch (DoesNotContainValueException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        element.setHint(ElementHints.KEY_ELEMENT_PROPERTIES, (Object)properties);
    }
}

