/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Container;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.TransactionSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.adapters.ISceneGraphProvider;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.threads.IThreadWorkQueue;

public class DiagramNodeUtil {
    public static ICanvasContext getCanvasContext(IG2DNode node) {
        G2DSceneGraph sg = node.getRootNode2D();
        if (sg == null) {
            return null;
        }
        Container rootPane = sg.getRootPane();
        if (rootPane == null) {
            throw new IllegalStateException("No root pane for scenegraph" + String.valueOf(sg));
        }
        AWTChassis chassis = (AWTChassis)rootPane.getParent();
        return chassis.getCanvasContext();
    }

    public static ICanvasContext getPossibleCanvasContext(IG2DNode node) {
        G2DSceneGraph sg = node.getRootNode2D();
        if (sg == null) {
            return null;
        }
        Container rootPane = sg.getRootPane();
        if (rootPane == null) {
            return null;
        }
        AWTChassis chassis = (AWTChassis)rootPane.getParent();
        return chassis.getCanvasContext();
    }

    public static IElement getElement(ICanvasContext ctx, IG2DNode node) {
        IDiagram diagram = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram != null) {
            SingleElementNode eNode = (SingleElementNode)NodeUtil.findNearestParentNode((INode)node, SingleElementNode.class);
            for (IElement e : diagram.getElements()) {
                INode n = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                if (n == null || node != n && eNode != n) continue;
                return e;
            }
        }
        return null;
    }

    public static IElement getElement(IG2DNode node) {
        ICanvasContext ctx = DiagramNodeUtil.getCanvasContext(node);
        if (ctx == null) {
            return null;
        }
        return DiagramNodeUtil.getElement(ctx, node);
    }

    public static void activateProfileWithEntries(final Resource runtime, final Resource profile, final Collection<Resource> entries) throws DatabaseException {
        VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
        Simantics.getSession().syncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

            public void perform(WriteGraph graph) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                graph.deny(runtime, DIA.RuntimeDiagram_HasRuntimeProfile);
                graph.claim(runtime, DIA.RuntimeDiagram_HasRuntimeProfile, profile);
                for (Resource entry : entries) {
                    graph.claim(profile, SIMU.IsActive, entry);
                }
            }
        });
    }

    private static Read<Resource> diagramToComposite(Resource diagram) throws DatabaseException {
        return new ResourceRead<Resource>(diagram){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                return graph.getPossibleObject(this.resource, mr.DiagramToComposite);
            }
        };
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProvider(Resource model, Resource diagram, String diagramRVI) throws DatabaseException {
        Resource composite = (Resource)Simantics.getSession().syncRequest(DiagramNodeUtil.diagramToComposite(diagram));
        return DiagramNodeUtil.loadSceneGraphProviderForComposite(model, composite, diagramRVI);
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProvider(ICanvasContext context, Resource model, Resource diagram, String diagramRVI) throws DatabaseException, InterruptedException {
        return DiagramNodeUtil.loadSceneGraphProvider(context, model, diagram, diagramRVI, 30000);
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProvider(ICanvasContext context, Resource model, Resource diagram, String diagramRVI, int timeoutMs) throws DatabaseException, InterruptedException {
        Resource composite = (Resource)Simantics.getSession().syncRequest(DiagramNodeUtil.diagramToComposite(diagram));
        if (composite != null) {
            return DiagramNodeUtil.loadSceneGraphProviderForComposite(context, model, composite, diagramRVI, timeoutMs);
        }
        return DiagramNodeUtil.loadSceneGraphProviderForDiagram(context, model, diagram, diagramRVI);
    }

    public static ICanvasContext loadDiagram(Resource model, Resource composite, String diagramRVI) throws DatabaseException, InterruptedException {
        String modelURI = (String)Simantics.getSession().syncRequest(Queries.uri((Resource)model));
        ISceneGraphProvider provider = (ISceneGraphProvider)Simantics.getSession().syncRequest(Queries.adapt((Resource)composite, ISceneGraphProvider.class));
        ICanvasSceneGraphProvider cp = (ICanvasSceneGraphProvider)provider;
        G2DSceneGraph sg = provider.initializeSceneGraph(new G2DSceneGraph(), modelURI, diagramRVI);
        NodeUtil.waitPending((IThreadWorkQueue)cp.getCanvasContext().getThreadAccess(), (G2DSceneGraph)sg);
        ((TransactionSupport)Simantics.getSession().getService(TransactionSupport.class)).waitCompletion();
        return cp.getCanvasContext();
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProviderForComposite(Resource model, Resource composite, String diagramRVI) throws DatabaseException {
        String modelURI = (String)Simantics.getSession().syncRequest(Queries.uri((Resource)model));
        ISceneGraphProvider provider = (ISceneGraphProvider)Simantics.getSession().syncRequest(Queries.adapt((Resource)composite, ISceneGraphProvider.class));
        ICanvasSceneGraphProvider cp = (ICanvasSceneGraphProvider)provider;
        G2DSceneGraph sg = cp.initializeSceneGraph(new G2DSceneGraph(), modelURI, diagramRVI);
        NodeUtil.waitPending((IThreadWorkQueue)cp.getCanvasContext().getThreadAccess(), (G2DSceneGraph)sg);
        ((TransactionSupport)Simantics.getSession().getService(TransactionSupport.class)).waitCompletion();
        return cp;
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProviderForComposite(ICanvasContext context, Resource model, Resource composite, String diagramRVI) throws DatabaseException, InterruptedException {
        return DiagramNodeUtil.loadSceneGraphProviderForComposite(context, model, composite, diagramRVI, 30000);
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProviderForComposite(ICanvasContext context, Resource model, Resource composite, String diagramRVI, int timeoutMs) throws DatabaseException, InterruptedException {
        String modelURI = (String)Simantics.getSession().syncRequest(Queries.uri((Resource)model));
        ISceneGraphProvider provider = (ISceneGraphProvider)Simantics.getSession().syncRequest(Queries.adapt((Resource)composite, ISceneGraphProvider.class));
        ICanvasSceneGraphProvider cp = (ICanvasSceneGraphProvider)provider;
        cp.initializeSceneGraph(context, modelURI, diagramRVI);
        NodeUtil.waitPending((IThreadWorkQueue)cp.getCanvasContext().getThreadAccess(), (G2DSceneGraph)context.getSceneGraph(), (int)timeoutMs);
        ((TransactionSupport)Simantics.getSession().getService(TransactionSupport.class)).waitCompletion();
        return cp;
    }

    public static ICanvasSceneGraphProvider loadSceneGraphProviderForDiagram(ICanvasContext context, Resource model, Resource diagram, String diagramRVI) throws DatabaseException, InterruptedException {
        String modelURI = (String)Simantics.getSession().syncRequest(Queries.uri((Resource)model));
        ISceneGraphProvider provider = (ISceneGraphProvider)Simantics.getSession().syncRequest(Queries.adapt((Resource)diagram, ISceneGraphProvider.class));
        ICanvasSceneGraphProvider cp = (ICanvasSceneGraphProvider)provider;
        cp.initializeSceneGraph(context, modelURI, diagramRVI);
        NodeUtil.waitPending((IThreadWorkQueue)cp.getCanvasContext().getThreadAccess(), (G2DSceneGraph)context.getSceneGraph());
        ((TransactionSupport)Simantics.getSession().getService(TransactionSupport.class)).waitCompletion();
        return cp;
    }

    public static IElement findElement(ICanvasContext ctx, Resource element) {
        IDiagram diagram = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        DataElementMap dmap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        return dmap.getElement(diagram, (Object)element);
    }

    public static INode findNode(ICanvasContext ctx, Resource element) {
        IElement e = DiagramNodeUtil.findElement(ctx, element);
        return (INode)e.getHint(ElementHints.KEY_SG_NODE);
    }

    public static Resource getRuntime(ICanvasContext ctx) {
        IDiagram diagram = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        return (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
    }

    public static Resource getElementResource(Resource configuration) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((Read)new ResourceRead<Resource>(configuration){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                return graph.getPossibleObject(this.resource, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement);
            }
        });
    }

    public static final Set<String> getTexts(Set<TextNode> nodes) {
        HashSet<String> result = new HashSet<String>(nodes.size());
        for (TextNode n : nodes) {
            result.add(n.getText());
        }
        return result;
    }
}

