/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import java.awt.Color;
import java.awt.Stroke;
import java.util.Arrays;
import org.simantics.g2d.element.handler.EdgeVisuals;

public class ConnectionVisuals {
    public final float[] color;
    public final EdgeVisuals.StrokeType strokeType;
    public final Stroke stroke;
    public final Double branchPointRadius;
    public final Double rounding;
    public final Double offset;

    public ConnectionVisuals(float[] color, EdgeVisuals.StrokeType strokeType, Stroke stroke, Double rounding) {
        this(color, strokeType, stroke, null, rounding);
    }

    public ConnectionVisuals(float[] color, EdgeVisuals.StrokeType strokeType, Stroke stroke, Double branchPointRadius, Double rounding) {
        this(color, strokeType, stroke, null, rounding, null);
    }

    public ConnectionVisuals(float[] color, EdgeVisuals.StrokeType strokeType, Stroke stroke, Double branchPointRadius, Double rounding, Double offset) {
        if (color != null && color.length < 3) {
            throw new IllegalArgumentException("colors must have at least 3 components (rgb), got " + color.length);
        }
        this.color = color;
        this.strokeType = strokeType;
        this.stroke = stroke;
        this.branchPointRadius = branchPointRadius;
        this.rounding = rounding;
        this.offset = offset;
    }

    public Color toColor() {
        if (this.color == null) {
            return null;
        }
        if (this.color.length == 3) {
            return new Color(this.color[2], this.color[1], this.color[0]);
        }
        return new Color(this.color[2], this.color[1], this.color[0], this.color[3]);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.branchPointRadius == null ? 0 : this.branchPointRadius.hashCode());
        result = 31 * result + Arrays.hashCode(this.color);
        result = 31 * result + (this.rounding == null ? 0 : this.rounding.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.stroke == null ? 0 : this.stroke.hashCode());
        result = 31 * result + (this.strokeType == null ? 0 : this.strokeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionVisuals other = (ConnectionVisuals)obj;
        if (this.branchPointRadius == null ? other.branchPointRadius != null : !this.branchPointRadius.equals(other.branchPointRadius)) {
            return false;
        }
        if (!Arrays.equals(this.color, other.color)) {
            return false;
        }
        if (this.rounding == null ? other.rounding != null : !this.rounding.equals(other.rounding)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        if (this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke)) {
            return false;
        }
        return this.strokeType == other.strokeType;
    }
}

