/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.svg.export;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGIDGenerator;
import org.simantics.diagram.svg.export.SVGGraphics2DWithPassthruSupport;
import org.simantics.diagram.svg.export.UniqueIDGenerator;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.page.MarginUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGBuilder {
    Double dpi;
    Point size;
    double margin;
    MarginUtils.Margins margins;
    public static final IHintContext.Key KEY_SVG_BUILDER = new IHintContext.KeyOf(Boolean.class, "SVG_BUILDER");

    public SVGBuilder(Double dpi, Point size, double margin) {
        this.dpi = dpi;
        this.size = size;
        this.margin = Math.max(margin, 0.0);
        this.margins = null;
    }

    public SVGBuilder(Double dpi, Point size, MarginUtils.Margins margins) {
        this.dpi = dpi;
        this.size = size;
        this.margin = 0.0;
        this.margins = margins;
    }

    public static SVGGraphics2D defaultSVGGenerator() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2DWithPassthruSupport svgGenerator = new SVGGraphics2DWithPassthruSupport(document);
        svgGenerator.getGeneratorContext().setIDGenerator((SVGIDGenerator)new UniqueIDGenerator(UUID.randomUUID().toString()));
        return svgGenerator;
    }

    public String paint(ICanvasContext canvasContext) throws Exception {
        return this.paint(canvasContext, SVGBuilder.defaultSVGGenerator());
    }

    public String paint(ICanvasContext canvasContext, SVGGraphics2D svgGenerator) throws Exception {
        Rectangle2D controlArea;
        SVGGraphics2D g2 = svgGenerator;
        IDiagram diagram = (IDiagram)canvasContext.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        Rectangle2D diagramRect = DiagramUtils.getContentRect((IDiagram)diagram);
        if (diagramRect == null) {
            diagramRect = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        }
        double off = Math.max(diagramRect.getWidth(), diagramRect.getHeight()) * this.margin * 0.5;
        diagramRect = new Rectangle2D.Double(diagramRect.getX() - off, diagramRect.getY() - off, diagramRect.getWidth() + off * 2.0, diagramRect.getHeight() + off * 2.0);
        if (this.margins != null) {
            diagramRect = GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)this.margins.top.diagramAbsolute, (double)this.margins.bottom.diagramAbsolute, (double)this.margins.left.diagramAbsolute, (double)this.margins.right.diagramAbsolute);
        }
        AffineTransform tr = new AffineTransform();
        if (this.dpi != null) {
            double mmToInch = 0.03937007874015748;
            controlArea = new Rectangle2D.Double(0.0, 0.0, diagramRect.getWidth() * mmToInch * this.dpi, diagramRect.getHeight() * mmToInch * this.dpi);
            if (this.margins != null) {
                double w = ((RectangularShape)controlArea).getWidth();
                double h = ((RectangularShape)controlArea).getHeight();
                controlArea = GeometryUtils.expandRectangle((Rectangle2D)controlArea, (double)(this.margins.top.controlAbsolute + this.margins.top.controlRelative * h), (double)(this.margins.bottom.controlAbsolute + this.margins.bottom.controlRelative * h), (double)(this.margins.left.controlAbsolute + this.margins.left.controlRelative * w), (double)(this.margins.right.controlAbsolute + this.margins.right.controlRelative * w));
            }
        } else {
            controlArea = new Rectangle2D.Double(0.0, 0.0, this.size.getX(), this.size.getY());
            if (this.margins != null) {
                double w = ((RectangularShape)controlArea).getWidth();
                double h = ((RectangularShape)controlArea).getHeight();
                controlArea = GeometryUtils.expandRectangle((Rectangle2D)controlArea, (double)(-(this.margins.top.controlAbsolute + this.margins.top.controlRelative * h)), (double)(-(this.margins.bottom.controlAbsolute + this.margins.bottom.controlRelative * h)), (double)(-(this.margins.left.controlAbsolute + this.margins.left.controlRelative * w)), (double)(-(this.margins.right.controlAbsolute + this.margins.right.controlRelative * w)));
            }
        }
        ((TransformUtil)canvasContext.getSingleItem(TransformUtil.class)).fitArea(controlArea, diagramRect, MarginUtils.NO_MARGINS);
        float width = (float)((RectangularShape)controlArea).getWidth();
        float height = (float)((RectangularShape)controlArea).getHeight();
        QualityHints.HIGH_QUALITY_HINTS.setQuality((Graphics2D)g2);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setTransform(tr);
        g2.setClip(new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
        g2.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS, new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
        if (canvasContext.isLocked()) {
            throw new IllegalStateException("cannot render image, canvas context is locked: " + String.valueOf(canvasContext));
        }
        canvasContext.getSceneGraph().render((Graphics2D)g2);
        Element root = svgGenerator.getRoot();
        root.setAttributeNS(null, "viewBox", "0 0 " + width + " " + height);
        root.setAttributeNS(null, "height", Float.toString(height));
        root.setAttributeNS(null, "width", Float.toString(width));
        boolean useCSS = false;
        StringWriter writer = new StringWriter();
        svgGenerator.stream(root, (Writer)writer, useCSS, false);
        return writer.toString();
    }
}

