/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.flag;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.utils.Alignment;

/**
 * @author Tuukka Lehtonen
 */
public interface IFlagType {

    /**
     * @author Tuukka Lehtonen
     * @see FlagInfoImpl
     */
    public interface FlagInfo {
        Shape getShape();
        String[] getText();
        Rectangle2D getTextArea();
        FlagClass.Type getType();
        Alignment getHorizontalAlignment();
        Alignment getVerticalAlignment();
        Font getFont();
    }

    /**
     * Reads and calculates information about this flags graphical
     * representation.
     * 
     * @param graph database read access
     * @return all info gathered up about the flag
     * @throws DatabaseException
     * @Deprecated implement {@link #getInfo(ReadGraph, ICanvasContext)} instead
     */
    default FlagInfo getInfo(ReadGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    /**
     * Reads and calculates information about this flags graphical
     * representation.
     * 
     * @param graph database read access
     * @param context the canvas context with which the info is loaded 
     * @return all info gathered up about the flag
     * @throws DatabaseException
     */
    default FlagInfo getInfo(ReadGraph graph, ICanvasContext context) throws DatabaseException {
        return getInfo(graph);
    }

}
