/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateProfileAction
extends ModelledActionImpl<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateProfileAction.class);

    public CreateProfileAction(Resource configuration) {
        super(configuration);
    }

    public void run(final Resource runtimeDiagram) {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    String modelURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
                    if (modelURI == null) {
                        return;
                    }
                    Resource model = graph.getPossibleResource(modelURI);
                    if (model == null) {
                        return;
                    }
                    String name = NameUtils.findFreshName((ReadGraph)graph, (String)"Profile", (Resource)model, (Resource)L0.ConsistsOf);
                    Resource list = OrderedSetUtils.create((WriteOnlyGraph)graph, (Resource)DIA.Profile);
                    Resource profile = graph.newResource();
                    graph.claim(profile, L0.InstanceOf, null, DIA.Profile);
                    graph.claimLiteral(profile, L0.HasName, (Object)name);
                    graph.claim(profile, DIA.HasEntries, null, list);
                    graph.claim(model, L0.ConsistsOf, profile);
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("CreateProfileAction failed", (Throwable)e);
        }
    }
}

