/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class AvailableProfiles
extends ReadFactoryImpl<Resource, List<Pair<String, Object>>> {
    public List<Pair<String, Object>> perform(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String modelURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
        if (modelURI == null) {
            return Collections.emptyList();
        }
        Resource model = graph.getPossibleResource(modelURI);
        if (model == null) {
            return Collections.emptyList();
        }
        Instances query = (Instances)graph.adapt(DIA.Profile, Instances.class);
        ArrayList<Pair<String, Object>> result = new ArrayList<Pair<String, Object>>();
        for (Resource profile : query.find(graph, model)) {
            if (graph.hasStatement(profile, L0.Abstract)) continue;
            String name = (String)graph.getRelatedValue(profile, L0.HasName, (Binding)Bindings.STRING);
            result.add((Pair<String, Object>)new Pair((Object)name, (Object)profile));
        }
        return result;
    }
}

