/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import java.util.Objects;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.graph.impl.InputSourceListener;
import org.simantics.browsing.ui.graph.impl.ObservableInputSource;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSessionContextInputSource;
import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.runtime.RuntimeDiagramManager;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.utils.ui.SWTUtils;

public class ActiveRuntimeDiagramInputSource
implements WorkbenchSessionContextInputSource,
ObservableInputSource,
IPartListener2,
Disposable {
    protected Display display;
    protected IWorkbenchPart ownerPart;
    protected IPartService service;
    protected IEditorPart activeEditor;
    protected Resource activeRuntimeDiagram;
    protected InputSourceListener listener;
    protected boolean ownerIsVisible = true;
    protected Resource lastInputResource;
    private InputProcedure inputProcedure = new InputProcedure();

    public void init(IWorkbenchSite site, IWorkbenchPart part) {
        this.display = site.getShell().getDisplay();
        this.ownerPart = part;
        this.attachToWorkbench();
    }

    protected void attachToWorkbench() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.service = window.getPartService();
        this.service.addPartListener((IPartListener2)this);
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null) {
            this.editorActivated(activeEditor);
        }
    }

    public void dispose() {
        if (this.service != null) {
            this.service.removePartListener((IPartListener2)this);
        }
        this.service = null;
        this.activeEditor = null;
        this.activeRuntimeDiagram = null;
        this.listener = null;
        this.ownerPart = null;
        this.display = null;
    }

    protected void fireIfInputChanged(Object oldSelection, Object newSelection) {
        InputSourceListener l = this.listener;
        if (l != null && !Objects.equals(oldSelection, newSelection)) {
            l.inputChanged((SessionContextInputSource)this);
        }
    }

    public Object get(ISessionContext ctx) {
        return this.activeRuntimeDiagram != null ? this.activeRuntimeDiagram : GraphExplorer.EMPTY_INPUT;
    }

    public IWorkbenchPart getProvider() {
        return this.activeEditor;
    }

    public void setListener(InputSourceListener listener) {
        this.listener = listener;
    }

    protected void testAndChangeInput(Resource resource) {
        Session session = Simantics.peekSession();
        if (session != null && resource != null) {
            session.asyncRequest((Read)new InputTransformation(resource, this.activeRuntimeDiagram), (Procedure)this.inputProcedure);
        } else {
            this.changeInput(null);
        }
    }

    protected void editorActivated(IEditorPart part) {
        RuntimeDiagramManager rdm = (RuntimeDiagramManager)part.getAdapter(RuntimeDiagramManager.class);
        Resource resource = null;
        if (rdm != null) {
            resource = rdm.getRuntimeDiagram();
        }
        if (resource == null) {
            resource = (Resource)part.getAdapter(Resource.class);
        }
        this.lastInputResource = resource;
        if (this.ownerIsVisible) {
            this.testAndChangeInput(resource);
        }
    }

    private boolean allEditorsClosed(IEditorPart forWindowOfPart) {
        IWorkbenchPage[] iWorkbenchPageArray = forWindowOfPart.getEditorSite().getWorkbenchWindow().getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] editors = page.getEditorReferences();
            if (editors.length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void activeEditorClosed() {
        if (this.allEditorsClosed(this.activeEditor)) {
            this.changeInput(null);
        }
    }

    private void changeInput(Resource newInput) {
        Resource oldInput = this.activeRuntimeDiagram;
        this.activeRuntimeDiagram = newInput;
        this.fireIfInputChanged(oldInput, newInput != null ? newInput : GraphExplorer.EMPTY_INPUT);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IEditorPart part;
        if (partRef instanceof IEditorReference && (part = ((IEditorReference)partRef).getEditor(false)) instanceof EditorPart) {
            this.editorActivated(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IEditorPart part;
        if (partRef instanceof IEditorReference && (part = ((IEditorReference)partRef).getEditor(false)) == this.activeEditor) {
            this.activeEditorClosed();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.ownerPart != null && this.ownerPart.equals(part)) {
            this.ownerIsVisible = false;
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.ownerPart != null && this.ownerPart.equals(part)) {
            this.ownerIsVisible = true;
            this.testAndChangeInput(this.lastInputResource);
        }
    }

    class InputProcedure
    implements Procedure<Resource> {
        InputProcedure() {
        }

        public void execute(Resource result) {
            Display d = ActiveRuntimeDiagramInputSource.this.display;
            if (d != null) {
                SWTUtils.asyncExec((Display)d, () -> ActiveRuntimeDiagramInputSource.this.changeInput(result));
            }
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }
    }

    private static class InputTransformation
    extends UniqueRead<Resource> {
        private Resource resource;
        private Resource defaultResult;

        public InputTransformation(Resource input, Resource defaultResult) {
            this.resource = input;
            this.defaultResult = defaultResult;
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            if (graph.isInstanceOf(this.resource, DiagramResource.getInstance((ReadGraph)graph).RuntimeDiagram)) {
                return this.resource;
            }
            if (!graph.hasStatement(this.resource)) {
                return null;
            }
            return this.defaultResult;
        }
    }
}

