/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.profile.commandlog.ToogleProfileGroupCommand;
import org.simantics.diagram.profile.view.ProfileTuple;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.profile.ProfileUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.strings.StringUtils;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Resource -> [Resource]")
    public static List<Resource> profileChildren(ReadGraph graph, Resource resource, Resource context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List listedChildren = ListUtils.toList((ReadGraph)graph, (Resource)context);
        if (listedChildren.isEmpty()) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            TreeMap<Double, Resource> priorityChildren = new TreeMap<Double, Resource>();
            for (Resource child : graph.getObjects(context, L0.IsComposedOf)) {
                Double p = (Double)graph.getPossibleRelatedValue(child, DIA.Profile_priority, (Binding)Bindings.DOUBLE);
                if (p == null) continue;
                priorityChildren.put(p, child);
            }
            return new ArrayList<Resource>(priorityChildren.values());
        }
        return listedChildren;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [(String, Resource)]")
    public static List<Tuple> availableProfiles(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource runtimeDiagram = ScenegraphLoaderUtils.getPossibleResourceSelection((ReadGraph)graph, (Variable)context);
        if (runtimeDiagram == null) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String modelURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
        if (modelURI == null) {
            return Collections.emptyList();
        }
        Resource model = graph.getPossibleResource(modelURI);
        if (model == null) {
            return Collections.emptyList();
        }
        Instances query = (Instances)graph.adapt(DIA.Profile, Instances.class);
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Resource profile : query.find(graph, model)) {
            if (graph.hasStatement(profile, L0.Abstract)) continue;
            String name = (String)graph.getRelatedValue(profile, L0.HasName, (Binding)Bindings.STRING);
            result.add((Tuple)new Tuple2((Object)name, (Object)profile));
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object profileEntrySelected(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Boolean>(){

            public void processRecursively(WriteGraph graph, Resource runtimeDiagram, Resource runtimeProfile, Resource entry, boolean checked) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(entry, DIA.Profile)) {
                    HashSet<Resource> singleSelGroups = new HashSet<Resource>();
                    for (Resource child : ProfileUtils.getProfileChildren((ReadGraph)graph, (Resource)entry)) {
                        Resource group;
                        if (checked && graph.isInstanceOf(child, DIA.ProfileEntry) && (group = graph.getPossibleObject(child, DIA.ProfileEntry_HasGroup)) != null && graph.isInstanceOf(group, DIA.SingleSelectionGroup)) {
                            if (singleSelGroups.contains(group)) continue;
                            singleSelGroups.add(group);
                        }
                        this.processRecursively(graph, runtimeDiagram, runtimeProfile, child, checked);
                    }
                } else if (graph.isInstanceOf(entry, DIA.ProfileEntry)) {
                    Resource group = graph.getPossibleObject(entry, DIA.ProfileEntry_HasGroup);
                    if (group != null && graph.isInstanceOf(group, DIA.SingleSelectionGroup)) {
                        if (checked) {
                            Collection entries = graph.getObjects(group, DIA.ProfileEntry_HasGroup_Inverse);
                            for (Resource e : entries) {
                                this.deactivate(graph, runtimeDiagram, runtimeProfile, e);
                            }
                            this.activate(graph, runtimeDiagram, runtimeProfile, entry);
                        } else {
                            this.deactivate(graph, runtimeDiagram, runtimeProfile, entry);
                        }
                    } else if (checked) {
                        this.activate(graph, runtimeDiagram, runtimeProfile, entry);
                    } else {
                        this.deactivate(graph, runtimeDiagram, runtimeProfile, entry);
                    }
                }
            }

            private void activate(WriteGraph graph, Resource runtimeDiagram, Resource runtimeProfile, Resource entry) throws DatabaseException {
                if (graph.isImmutable(runtimeProfile)) {
                    Resource activationState = ProfileUtils.claimProfileActivationState((WriteGraph)graph, (Resource)runtimeDiagram, (Resource)runtimeProfile, (Resource)entry);
                    if (activationState != null) {
                        graph.claim(activationState, SimulationResource.getInstance((ReadGraph)graph).IsActive, null, entry);
                    }
                } else {
                    graph.claim(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, null, entry);
                }
            }

            private void deactivate(WriteGraph graph, Resource runtimeDiagram, Resource runtimeProfile, Resource entry) throws DatabaseException {
                if (graph.isImmutable(runtimeProfile)) {
                    Resource activationState = ProfileUtils.claimProfileActivationState((WriteGraph)graph, (Resource)runtimeDiagram, (Resource)runtimeProfile, (Resource)entry);
                    if (activationState != null) {
                        graph.denyStatement(activationState, SimulationResource.getInstance((ReadGraph)graph).IsActive, entry);
                    }
                } else {
                    graph.denyStatement(runtimeProfile, SimulationResource.getInstance((ReadGraph)graph).IsActive, entry);
                }
            }

            public Boolean apply(Object _event) {
                Event event = (Event)_event;
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    Tree tree = item.getParent();
                    GraphExplorer explorer = (GraphExplorer)tree.getData("GraphExplorer");
                    final Resource runtimeDiagram = (Resource)explorer.getRoot().getConstant(BuiltinKeys.INPUT);
                    final boolean checked = item.getChecked();
                    NodeContext context = (NodeContext)item.getData();
                    final ProfileTuple entry = (ProfileTuple)((Object)context.getConstant(BuiltinKeys.INPUT));
                    try {
                        VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
                        Simantics.getSession().syncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                                Resource runtimeProfile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                                this.processRecursively(graph, runtimeDiagram, runtimeProfile, entry.getEntry(), checked);
                                if (Commands.isRecording()) {
                                    Commands.record((Object)graph, (Command)new ToogleProfileGroupCommand(runtimeProfile, entry.getEntry(), checked));
                                }
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object selectedProfile(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource runtimeDiagram = ScenegraphLoaderUtils.getResourceSelection((ReadGraph)graph, (Variable)context);
        if (runtimeDiagram == null) {
            return "";
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
        if (profile == null) {
            return null;
        }
        String name = (String)graph.getPossibleRelatedValue(profile, L0.HasName, (Binding)Bindings.STRING);
        return StringUtils.safeString((String)name);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object activeProfileModifier(ReadGraph graph, final Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<String, String>(){

            public String apply(final String key) {
                VirtualGraphSupport support = (VirtualGraphSupport)Simantics.getSession().getService(VirtualGraphSupport.class);
                Simantics.getSession().asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

                    public Resource selected(List<Tuple> avail, String text) {
                        for (Tuple a : avail) {
                            if (!a.get(0).equals(text)) continue;
                            return (Resource)a.get(1);
                        }
                        return null;
                    }

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource runtimeDiagram = ScenegraphLoaderUtils.getResourceSelection((ReadGraph)graph, (Variable)context);
                        List<Tuple> avail = All.availableProfiles((ReadGraph)graph, resource, context);
                        Resource profile = this.selected(avail, key);
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        Resource current = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                        if (profile.equals(current)) {
                            return;
                        }
                        graph.deny(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                        graph.claim(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile, null, profile);
                        String modelURI = (String)graph.getRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
                        Resource model = graph.getResource(modelURI);
                        graph.deny(model, DIA.HasActiveProfile);
                        graph.claim(model, DIA.HasActiveProfile, profile);
                        Resource configuration = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
                        graph.deny(configuration, DIA.HasActiveProfile);
                        graph.claim(configuration, DIA.HasActiveProfile, profile);
                    }
                });
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource singleResourceSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getPossibleResourceSelection((ReadGraph)graph, (Variable)context);
    }
}

