/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.splitting;

import gnu.trove.set.hash.THashSet;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.segments.Segment;

public class SplittedRouteGraph {
    public final RouteLine splitLine;
    public final THashSet<RouteNode> interfaceNodes1;
    public final THashSet<RouteLine> lines1;
    public final THashSet<RouteTerminal> terminals1;
    public final THashSet<RouteNode> interfaceNodes2;
    public final THashSet<RouteLine> lines2;
    public final THashSet<RouteTerminal> terminals2;

    public SplittedRouteGraph(RouteLine splitLine, THashSet<RouteNode> interfaceNodes1, THashSet<RouteLine> lines1, THashSet<RouteTerminal> terminals1, THashSet<RouteNode> interfaceNodes2, THashSet<RouteLine> lines2, THashSet<RouteTerminal> terminals2) {
        this.splitLine = splitLine;
        this.interfaceNodes1 = interfaceNodes1;
        this.lines1 = lines1;
        this.terminals1 = terminals1;
        this.interfaceNodes2 = interfaceNodes2;
        this.lines2 = lines2;
        this.terminals2 = terminals2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("splitLine = " + String.valueOf(this.splitLine.getData()) + "\n");
        b.append("interfaceNodes1 =");
        for (RouteNode node : this.interfaceNodes1) {
            b.append(" " + String.valueOf(node.getData()) + "(" + node.getClass().getSimpleName() + ")");
        }
        b.append("\n");
        b.append("lines1 =");
        for (RouteNode node : this.lines1) {
            b.append(" " + String.valueOf(((RouteLine)node).getData()));
        }
        b.append("\n");
        b.append("terminals1 =");
        for (RouteNode node : this.terminals1) {
            b.append(" " + String.valueOf(((RouteTerminal)node).getData()));
        }
        b.append("\n");
        b.append("interfaceNodes2 =");
        for (RouteNode node : this.interfaceNodes2) {
            b.append(" " + String.valueOf(node.getData()) + "(" + node.getClass().getSimpleName() + ")");
        }
        b.append("\n");
        b.append("lines2 =");
        for (RouteNode node : this.lines2) {
            b.append(" " + String.valueOf(((RouteLine)node).getData()));
        }
        b.append("\n");
        b.append("terminals2 =");
        for (RouteNode node : this.terminals2) {
            b.append(" " + String.valueOf(((RouteTerminal)node).getData()));
        }
        b.append("\n");
        return b.toString();
    }

    public static RouteLine findNearestLine(RouteGraph rg, Point2D splitCanvasPos) {
        double hi = 1000.0;
        double lo = 1.0;
        RouteLine nearestLine = null;
        while (true) {
            double tolerance = (hi + lo) * 0.5;
            RouteLine line = rg.pickLine(splitCanvasPos.getX(), splitCanvasPos.getY(), tolerance);
            double delta = (hi - lo) * 0.5;
            if (delta < 0.5) {
                return nearestLine;
            }
            if (line == null) {
                lo = tolerance;
                continue;
            }
            nearestLine = line;
            hi = tolerance;
        }
    }

    public static PickResult pickNearestLine(RouteGraph rg, double x, double y) {
        Segment nearestSegment = null;
        RouteLine nearestLine = null;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        double minDistanceSq = Double.MAX_VALUE;
        for (RouteLine line : rg.getAllLines()) {
            segments.clear();
            line.collectSegments(segments);
            for (Segment segment : segments) {
                RoutePoint p1 = segment.p1;
                RoutePoint p2 = segment.p2;
                double distanceSq = Line2D.ptSegDistSq(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x, y);
                if (!(distanceSq < minDistanceSq)) continue;
                minDistanceSq = distanceSq;
                nearestSegment = segment;
                nearestLine = line;
            }
        }
        if (nearestSegment == null) {
            return null;
        }
        RoutePoint p1 = nearestSegment.p1;
        RoutePoint p2 = nearestSegment.p2;
        Point2D p = SplittedRouteGraph.pointToLineIntersection(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x, y);
        return new PickResult(nearestLine, new Point2D.Double(x, y), p);
    }

    private static Point2D pointToLineIntersection(double x1, double y1, double x2, double y2, double px, double py) {
        double d = Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0);
        if (d == 0.0) {
            return new Point2D.Double(x1, y1);
        }
        double u = ((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / d;
        if (u > 1.0) {
            return new Point2D.Double(x2, y2);
        }
        if (u <= 0.0) {
            return new Point2D.Double(x1, y1);
        }
        return new Point2D.Double(x2 * u + x1 * (1.0 - u), y2 * u + y1 * (1.0 - u));
    }

    public static Point2D snapToLine(Point2D point, RouteLine line) {
        if (line.isHorizontal()) {
            point.setLocation(point.getX(), line.getPosition());
        } else {
            point.setLocation(line.getPosition(), point.getY());
        }
        return point;
    }

    public static Point2D snappedToLine(Point2D point, RouteLine line) {
        Point2D result = (Point2D)point.clone();
        return SplittedRouteGraph.snapToLine(result, line);
    }

    public static final class PickResult {
        public final RouteLine nearestLine;
        public final Point2D pickPoint;
        public final Point2D intersectionPoint;

        public PickResult(RouteLine nearestLine, Point2D pickPoint, Point2D intersectionPoint) {
            this.nearestLine = nearestLine;
            this.pickPoint = pickPoint;
            this.intersectionPoint = intersectionPoint;
        }
    }
}

