/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.segments;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.set.hash.THashSet;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.diagram.connection.segments.Segment;

public class GeometricSegment {
    public final double x1;
    public final double y1;
    public final boolean isBranching1;
    public final double x2;
    public final double y2;
    public final boolean isBranching2;

    public GeometricSegment(double x1, double y1, boolean isBranching1, double x2, double y2, boolean isBranching2) {
        this.x1 = x1;
        this.y1 = y1;
        this.isBranching1 = isBranching1;
        this.x2 = x2;
        this.y2 = y2;
        this.isBranching2 = isBranching2;
    }

    public boolean isOnSegment(double x, double y) {
        double dist = GeometricSegment.distanceFrom(this.x1, this.y1, this.x2, this.y2, x, y);
        return dist == 0.0;
    }

    public static List<GeometricSegment> convert(Collection<Segment> segments) {
        TObjectIntHashMap pointCounts = new TObjectIntHashMap();
        for (Segment segment : segments) {
            pointCounts.adjustOrPutValue((Object)segment.p1, 1, 1);
            pointCounts.adjustOrPutValue((Object)segment.p2, 1, 1);
        }
        for (Segment segment : segments) {
            if (!segment.isDegenerated()) continue;
            int count = pointCounts.get((Object)segment.p1) + pointCounts.get((Object)segment.p2) - 2;
            pointCounts.put((Object)segment.p1, count);
            pointCounts.put((Object)segment.p2, count);
        }
        ArrayList<GeometricSegment> result = new ArrayList<GeometricSegment>();
        for (Segment segment : segments) {
            if (segment.isDegenerated()) continue;
            result.add(new GeometricSegment(segment.p1.getX(), segment.p1.getY(), pointCounts.get((Object)segment.p1) > 2, segment.p2.getX(), segment.p2.getY(), pointCounts.get((Object)segment.p2) > 2));
        }
        return result;
    }

    public static List<GeometricSegment> optimize(List<GeometricSegment> segments) {
        if (segments.size() == 1) {
            return segments;
        }
        TObjectIntHashMap degree = new TObjectIntHashMap();
        TObjectIntHashMap branched = new TObjectIntHashMap();
        THashMap segmentsOfPoint = new THashMap();
        for (GeometricSegment seg : segments) {
            Point2D.Double p1 = new Point2D.Double(seg.x1, seg.y1);
            Point2D.Double p2 = new Point2D.Double(seg.x2, seg.y2);
            degree.adjustOrPutValue((Object)p1, 1, 1);
            degree.adjustOrPutValue((Object)p2, 1, 1);
            int bi1 = seg.isBranching1 ? 1 : 0;
            int bi2 = seg.isBranching2 ? 1 : 0;
            branched.adjustOrPutValue((Object)p1, bi1, bi1);
            branched.adjustOrPutValue((Object)p2, bi2, bi2);
            GeometricSegment.addSegmentToPoint(p1, seg, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
            GeometricSegment.addSegmentToPoint(p2, seg, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
        }
        ArrayList unnecessaryPoints = new ArrayList(segments.size());
        degree.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<Point2D>((TObjectIntMap)branched, (Map)segmentsOfPoint, unnecessaryPoints){
            private final /* synthetic */ TObjectIntMap val$branched;
            private final /* synthetic */ Map val$segmentsOfPoint;
            private final /* synthetic */ List val$unnecessaryPoints;
            {
                this.val$branched = tObjectIntMap;
                this.val$segmentsOfPoint = map;
                this.val$unnecessaryPoints = list;
            }

            public boolean execute(Point2D a, int branchCount) {
                if (branchCount == 2 && this.val$branched.get((Object)a) == 0) {
                    List segs = (List)this.val$segmentsOfPoint.get(a);
                    if (!$assertionsDisabled && segs.size() != 2) {
                        throw new AssertionError();
                    }
                    GeometricSegment seg = GeometricSegment.join(a, (GeometricSegment)segs.get(0), (GeometricSegment)segs.get(1));
                    if (seg.isOnSegment(a.getX(), a.getY())) {
                        this.val$unnecessaryPoints.add(a);
                    }
                }
                return true;
            }
        });
        if (unnecessaryPoints.isEmpty()) {
            return segments;
        }
        Point2D.Double p = new Point2D.Double();
        for (Point2D dp : unnecessaryPoints) {
            List segs = (List)segmentsOfPoint.remove(dp);
            assert (segs.size() == 2);
            GeometricSegment joined = GeometricSegment.join(dp, (GeometricSegment)segs.get(0), (GeometricSegment)segs.get(1));
            GeometricSegment a = (GeometricSegment)segs.get(0);
            a.otherEnd(dp, p);
            GeometricSegment.removeSegmentFromPoint(p, a, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
            GeometricSegment.addSegmentToPoint(p, joined, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
            GeometricSegment b = (GeometricSegment)segs.get(1);
            b.otherEnd(dp, p);
            GeometricSegment.removeSegmentFromPoint(p, b, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
            GeometricSegment.addSegmentToPoint(p, joined, (Map<Point2D, List<GeometricSegment>>)segmentsOfPoint);
        }
        ArrayList<GeometricSegment> result = new ArrayList<GeometricSegment>(segments.size());
        THashSet processed = new THashSet();
        for (List segs : segmentsOfPoint.values()) {
            for (GeometricSegment seg : segs) {
                if (!processed.add(seg)) continue;
                result.add(seg);
            }
        }
        return result;
    }

    private Point2D otherEnd(Point2D oneEnd, Point2D otherEnd) {
        double x = oneEnd.getX();
        double y = oneEnd.getY();
        double rx = this.x1;
        double ry = this.y1;
        if (x == this.x1 && y == this.y1) {
            rx = this.x2;
            ry = this.y2;
        }
        otherEnd.setLocation(rx, ry);
        return otherEnd;
    }

    private static GeometricSegment join(Point2D at, GeometricSegment s1, GeometricSegment s2) {
        double x = at.getX();
        double y = at.getY();
        double x1 = s1.x1;
        double y1 = s1.y1;
        boolean b1 = s1.isBranching1;
        if (x == s1.x1 && y == s1.y1) {
            x1 = s1.x2;
            y1 = s1.y2;
            b1 = s1.isBranching2;
        }
        double x2 = s2.x1;
        double y2 = s2.y1;
        boolean b2 = s2.isBranching1;
        if (x == s2.x1 && y == s2.y1) {
            x2 = s2.x2;
            y2 = s2.y2;
            b1 = s2.isBranching2;
        }
        return new GeometricSegment(x1, y1, b1, x2, y2, b2);
    }

    private static void addSegmentToPoint(Point2D p, GeometricSegment seg, Map<Point2D, List<GeometricSegment>> segmentsOfPoint) {
        List<GeometricSegment> l = segmentsOfPoint.get(p);
        if (l == null) {
            l = new ArrayList<GeometricSegment>(4);
            segmentsOfPoint.put(p, l);
        }
        l.add(seg);
    }

    private static boolean removeSegmentFromPoint(Point2D p, GeometricSegment seg, Map<Point2D, List<GeometricSegment>> segmentsOfPoint) {
        List<GeometricSegment> l = segmentsOfPoint.get(p);
        return l != null ? l.remove(seg) : false;
    }

    private static double distanceFrom(double x1, double y1, double x2, double y2, double px, double py) {
        double lineLenSq;
        double lineLen;
        double projLen;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((projLen = dotprod / (lineLen = Math.sqrt(lineLenSq = x2 * x2 + y2 * y2))) < 0.0) {
            return Math.sqrt(px * px + py * py);
        }
        if (projLen > lineLen) {
            double dx = px - x2;
            double dy = py - y2;
            return Math.sqrt(dx * dx + dy * dy);
        }
        return Math.sqrt(px * px + py * py - projLen * projLen);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[(" + this.x1 + ", " + this.y1 + ", " + this.isBranching1 + ") <-> (" + this.x2 + ", " + this.y2 + ", " + this.isBranching2 + ")]";
    }
}

