/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering.arrows;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public enum ArrowExampleLineEndStyle implements ILineEndStyle,
Serializable
{
    INSTANCE;

    public static final double length = 8.0;
    public static final double width = 4.0;
    public static final double space = 10.0;

    @Override
    public void render(Graphics2D g, double x, double y, int dir) {
        AffineTransform old = g.getTransform();
        g.translate(x, y);
        g.rotate((double)dir * Math.PI * 0.5);
        g.fill(new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0));
        Path2D.Double path = new Path2D.Double();
        path.moveTo(-10.0, 0.0);
        path.lineTo(-18.0, -4.0);
        path.lineTo(-18.0, 4.0);
        path.closePath();
        g.fill(path);
        g.setTransform(old);
    }

    @Override
    public double getLineEndLength(int direction) {
        return 18.0;
    }
}

