/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.io.Serializable;
import org.simantics.diagram.connection.rendering.ConnectionStyle;

public class ExampleConnectionStyle
implements ConnectionStyle,
Serializable {
    private static final long serialVersionUID = -5799681720482456895L;
    public static final BasicStroke SOLID = new BasicStroke(1.0f);
    public static final BasicStroke BOLD = new BasicStroke(3.0f, 0, 2);

    @Override
    public void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, boolean isTransient) {
        g.setColor(Color.BLACK);
        if (isTransient) {
            g.draw(new Line2D.Double(x1, y1, x2, y2));
        } else {
            g.setStroke(BOLD);
            g.draw(new Line2D.Double(x1, y1, x2, y2));
            g.setStroke(SOLID);
        }
    }

    @Override
    public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
        g.setColor(Color.BLACK);
        if (isTransient) {
            g.draw(path);
        } else {
            g.setStroke(BOLD);
            g.draw(path);
            g.setStroke(SOLID);
        }
    }

    @Override
    public void drawBranchPoint(Graphics2D g, double x, double y) {
        g.setColor(Color.BLACK);
        g.fill(new Ellipse2D.Double(x - 3.0, y - 3.0, 6.0, 6.0));
    }

    @Override
    public void drawDegeneratedLine(Graphics2D g, double x, double y, boolean isHorizontal, boolean isTransient) {
        double d = this.getDegeneratedLineLength() * 0.5;
        if (isHorizontal) {
            g.draw(new Line2D.Double(x - d, y, x + d, y));
        } else {
            g.draw(new Line2D.Double(x, y - d, x, y + d));
        }
    }

    @Override
    public double getDegeneratedLineLength() {
        return 8.0;
    }
}

