/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.diagram.connection.rendering.PathModifier;

public class ConnectionCrossings
implements PathModifier {
    private List<Segment> segments = new ArrayList<Segment>();
    private double width;
    private double widthd2;
    private Type type;
    private boolean keepLines = false;

    public void setWidth(double gapWidth) {
        this.width = gapWidth;
        this.widthd2 = this.width * 0.5;
    }

    public double getWidth() {
        return this.width;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public void reset() {
        this.segments.clear();
    }

    static Double lineLineIntersection(Segment l1, Segment l2) {
        double t;
        double epsilon = 0.001;
        double d = (l1.x1 - l1.x2) * (l2.y1 - l2.y2) - (l1.y1 - l1.y2) * (l2.x1 - l2.x2);
        if (d == 0.0) {
            return null;
        }
        double s = ((l1.x1 - l2.x1) * (l2.y1 - l2.y2) - (l1.y1 - l2.y1) * (l2.x1 - l2.x2)) / d;
        if (s > epsilon && s < 1.0 - epsilon && (t = -((l1.x1 - l1.x2) * (l1.y1 - l2.y1) - (l1.y1 - l1.y2) * (l1.x1 - l2.x1)) / d) > epsilon && t < 1.0 - epsilon) {
            return t;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Path2D modify(Path2D path) {
        block36: {
            path2 = new Path2D.Double();
            iter = path.getPathIterator(null);
            if (this.isKeepLines()) ** GOTO lbl140
            while (!iter.isDone()) {
                c = new double[6];
                i = iter.currentSegment(c);
                switch (i) {
                    case 0: {
                        path2.moveTo(c[0], c[1]);
                        break;
                    }
                    case 1: {
                        l = new Segment(path2.getCurrentPoint().getX(), path2.getCurrentPoint().getY(), c[0], c[1]);
                        gaps = new ArrayList<Double>();
                        for (Segment old : this.segments) {
                            t = ConnectionCrossings.lineLineIntersection(old, l);
                            if (t == null) continue;
                            gaps.add(t);
                        }
                        if (gaps.isEmpty()) {
                            path2.lineTo(c[0], c[1]);
                        } else {
                            Collections.sort(gaps);
                            dx = l.x2 - l.x1;
                            dy = l.y2 - l.y1;
                            pos = 0.0;
                            len = Math.sqrt(dx * dx + dy * dy);
                            len1 = 1.0 / len;
                            finish = true;
                            prevGapEnd = null;
                            for (Double gapCenter : gaps) {
                                pos2 = gapCenter - this.widthd2 * len1;
                                pos3 = gapCenter + this.widthd2 * len1;
                                if (pos2 > pos) {
                                    this.handleGap(path2, prevGapEnd);
                                    prevGapEnd = null;
                                    path2.lineTo(l.x1 + pos2 * dx, l.y1 + pos2 * dy);
                                }
                                if (pos3 < 1.0) {
                                    x = l.x1 + pos3 * dx;
                                    y = l.y1 + pos3 * dy;
                                    prevGapEnd = new Point2D.Double(x, y);
                                } else {
                                    finish = false;
                                }
                                pos = pos3;
                            }
                            if (finish) {
                                this.handleGap(path2, prevGapEnd);
                                path2.lineTo(l.x2, l.y2);
                            } else {
                                prevGapEnd = new Point2D.Double(l.x2, l.y2);
                                this.handleGap(path2, prevGapEnd);
                            }
                        }
                        this.segments.add(l);
                        break;
                    }
                    case 2: {
                        path2.quadTo(c[0], c[1], c[2], c[3]);
                        break;
                    }
                    case 3: {
                        path2.curveTo(c[0], c[1], c[2], c[3], c[4], c[5]);
                        break;
                    }
                    case 4: {
                        path2.closePath();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected segment type " + i);
                    }
                }
                iter.next();
            }
            break block36;
lbl-1000:
            // 1 sources

            {
                c = new double[6];
                i = iter.currentSegment(c);
                switch (i) {
                    case 0: {
                        path2.moveTo(c[0], c[1]);
                        break;
                    }
                    case 1: {
                        l = new Segment(path2.getCurrentPoint().getX(), path2.getCurrentPoint().getY(), c[0], c[1]);
                        gaps = new ArrayList<Double>();
                        for (Segment old : this.segments) {
                            t = ConnectionCrossings.lineLineIntersection(old, l);
                            if (t == null) continue;
                            gaps.add(t);
                        }
                        if (gaps.isEmpty()) {
                            path2.lineTo(c[0], c[1]);
                        } else {
                            Collections.sort(gaps);
                            dx = l.x2 - l.x1;
                            dy = l.y2 - l.y1;
                            pos = 0.0;
                            len = Math.sqrt(dx * dx + dy * dy);
                            len1 = 1.0 / len;
                            finish = true;
                            prevGapEnd = null;
                            j = 0;
                            while (j < gaps.size()) {
                                gapCenter = (Double)gaps.get(j);
                                gc = gapCenter * len;
                                pos2 = gc - this.widthd2;
                                pos3 = gc + this.widthd2;
                                if (j == 0 && pos2 < this.widthd2) {
                                    pos2 += (this.widthd2 - pos2) * 0.5;
                                }
                                if (j == gaps.size() - 1 && (d = len - pos3) < this.widthd2) {
                                    pos3 -= (this.widthd2 - d) * 0.5;
                                }
                                if (pos2 > pos) {
                                    this.handleGap(path2, prevGapEnd);
                                    prevGapEnd = null;
                                    path2.lineTo(l.x1 + (pos2 *= len1) * dx, l.y1 + pos2 * dy);
                                }
                                if (pos3 < len) {
                                    pos = pos3;
                                    x = l.x1 + (pos3 *= len1) * dx;
                                    y = l.y1 + pos3 * dy;
                                    prevGapEnd = new Point2D.Double(x, y);
                                } else {
                                    pos = pos3;
                                    finish = false;
                                }
                                ++j;
                            }
                            if (finish) {
                                this.handleGap(path2, prevGapEnd);
                                path2.lineTo(l.x2, l.y2);
                            } else {
                                prevGapEnd = new Point2D.Double(l.x2, l.y2);
                                this.handleGap(path2, prevGapEnd);
                            }
                        }
                        this.segments.add(l);
                        break;
                    }
                    case 2: {
                        path2.quadTo(c[0], c[1], c[2], c[3]);
                        break;
                    }
                    case 3: {
                        path2.curveTo(c[0], c[1], c[2], c[3], c[4], c[5]);
                        break;
                    }
                    case 4: {
                        path2.closePath();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected segment type " + i);
                    }
                }
                iter.next();
lbl140:
                // 2 sources

                ** while (!iter.isDone())
            }
        }
        return path2;
    }

    private void handleGap(Path2D path, Point2D prevGapEnd) {
        if (prevGapEnd != null) {
            switch (this.type) {
                case ARC: {
                    ConnectionCrossings.arcTo(path, prevGapEnd.getX(), prevGapEnd.getY());
                    break;
                }
                case SQUARE: {
                    ConnectionCrossings.squareTo(path, prevGapEnd.getX(), prevGapEnd.getY(), this.width);
                    break;
                }
                case GAP: {
                    path.moveTo(prevGapEnd.getX(), prevGapEnd.getY());
                    break;
                }
            }
        }
    }

    private static void arcTo(Path2D path, double x2, double y2) {
        Arc2D.Double arc = new Arc2D.Double();
        double x1 = path.getCurrentPoint().getX();
        double y1 = path.getCurrentPoint().getY();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double r = Math.sqrt(dx * dx + dy * dy) / 2.0;
        double angle = Math.atan2(dx, dy) * 180.0 / Math.PI + 90.0;
        double span = angle > 225.0 || angle < 45.0 ? 180 : -180;
        arc.setArcByCenter((x1 + x2) / 2.0, (y1 + y2) / 2.0, r, angle, span, 0);
        path.append(arc, true);
    }

    private static void squareTo(Path2D path, double x2, double y2, double width) {
        double y1;
        double dy;
        double x1 = path.getCurrentPoint().getX();
        double dx = x2 - x1;
        double l = Math.sqrt(dx * dx + (dy = y2 - (y1 = path.getCurrentPoint().getY())) * dy);
        if (l > 0.0) {
            double nx = -dy / l;
            double ny = dx / l;
            if (nx - ny < 0.0) {
                nx = -nx;
                ny = -ny;
            }
            path.lineTo(x1 + nx * width / 2.0, y1 + ny * width / 2.0);
            path.lineTo(x2 + nx * width / 2.0, y2 + ny * width / 2.0);
            path.lineTo(x2, y2);
        }
    }

    static class Segment {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Segment(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }

    public static enum Type {
        NONE,
        GAP,
        ARC,
        SQUARE;

    }
}

