/*******************************************************************************
 * Copyright (c) 2022 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;

/**
 * Route point that is connected to two direct terminals.
 * 
 * @author Hannu Niemisto
 */
public class DegeneratedRoutePoint extends RoutePoint {

    public DegeneratedRoutePoint() {
        super();
    }

    public DegeneratedRoutePoint(double x, double y) {
        super(x, y);
    }

    @Override
    DegeneratedRoutePoint copy(THashMap<Object, Object> map) {
        DegeneratedRoutePoint copy = (DegeneratedRoutePoint) map.get(this);
        if (copy == null) {
            copy = new DegeneratedRoutePoint(x, y);
            map.put(this, copy);
        }
        return copy;
    }

}