/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.debug.graphical.model.Content;
import org.simantics.debug.graphical.model.NodeData;

public class Node {
    public static final Font FONT = new Font("Arial", 0, 12);
    public static final FontRenderContext FRC = new FontRenderContext(new AffineTransform(), true, true);
    public static final Rectangle2D MAX_BOUNDS = FONT.getMaxCharBounds(FRC);
    public static final double FONT_HEIGHT = MAX_BOUNDS.getHeight();
    public static double PADDING = 3.0;
    NodeData data;
    Content content;
    double x;
    double y;
    double radiusX;
    double radiusY;
    public double forceX;
    public double forceY;

    public Node(NodeData data) {
        this.data = data;
    }

    public void setContent(Content content) {
        this.content = content;
        this.radiusX = content.radiusX;
        this.radiusY = content.radiusY;
    }

    public NodeData getData() {
        return this.data;
    }

    public void setPos(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void render(Graphics2D g) {
        Rectangle2D.Double rect = new Rectangle2D.Double(this.x - this.radiusX, this.y - this.radiusY, 2.0 * this.radiusX, 2.0 * this.radiusY);
        g.setColor(new Color(200, 200, 255));
        g.fill(rect);
        g.setColor(Color.BLACK);
        if (this.content != null) {
            this.content.render(g, this.x, this.y);
        }
        g.draw(rect);
    }

    public Point2D clipLineFromCenter(double targetX, double targetY) {
        targetX -= this.x;
        if (this.radiusX * Math.abs(targetY -= this.y) < this.radiusY * Math.abs(targetX)) {
            return new Point2D.Double(this.x + Math.signum(targetX) * this.radiusX, this.y + targetY * this.radiusX / Math.abs(targetX));
        }
        return new Point2D.Double(this.x + targetX * this.radiusY / Math.abs(targetY), this.y + Math.signum(targetY) * this.radiusY);
    }

    public boolean pick(double px, double py) {
        return Math.abs(px - this.x) <= this.radiusX && Math.abs(py - this.y) <= this.radiusY;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getMinX() {
        return this.x - this.radiusX;
    }

    public double getMinY() {
        return this.y - this.radiusY;
    }

    public double getMaxX() {
        return this.x + this.radiusX;
    }

    public double getMaxY() {
        return this.y + this.radiusY;
    }
}

