/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.model;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.debug.graphical.model.Content;

public class LabelContent
extends Content {
    public static final Font FONT = new Font("Arial", 0, 12);
    public static final FontRenderContext FRC = new FontRenderContext(new AffineTransform(), true, true);
    public static final Rectangle2D MAX_BOUNDS = FONT.getMaxCharBounds(FRC);
    public static final double FONT_HEIGHT = MAX_BOUNDS.getHeight();
    public static double PADDING = 3.0;
    String[] labels;
    double textX;
    double textY;

    public LabelContent(String[] labels) {
        this.setLabels(labels);
    }

    @Override
    public void render(Graphics2D g) {
        g.setFont(FONT);
        int i = 0;
        while (i < this.labels.length) {
            g.drawString(this.labels[i], (float)this.textX, (float)(this.textY + (double)i * FONT_HEIGHT));
            ++i;
        }
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
        double maxWidth = 0.0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            Rectangle2D bounds = FONT.getStringBounds(label, FRC);
            maxWidth = Math.max(maxWidth, bounds.getWidth());
            ++n2;
        }
        this.textX = -0.5 * maxWidth;
        this.textY = -0.5 * (double)labels.length * FONT_HEIGHT + FONT_HEIGHT - MAX_BOUNDS.getMaxY();
        this.radiusX = PADDING + 0.5 * maxWidth;
        this.radiusY = PADDING + 0.5 * (double)labels.length * FONT_HEIGHT;
    }
}

