package org.simantics.debug.graphical.model;

import java.util.ArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.graphical.LabelingPreferences;
import org.simantics.layer0.Layer0;

public class NodeData {
    Resource resource;    
    String[] labels;
    ArrayList<Statement> statements = new ArrayList<Statement>();
    
    public NodeData(Resource resource) {
        this.resource = resource;
    }

    public String[] getLabels() {
        return labels;
    }
    
    public void updateData(ReadGraph g, LabelingPreferences pref) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        
        Resource name = null;
        Resource label = null;
        ArrayList<Resource> types = new ArrayList<Resource>(); 
        ArrayList<Resource> tags = new ArrayList<Resource>();
        
        statements.clear();
        for(Statement stat : g.getStatements(resource, L0.IsWeaklyRelatedTo)) {
            if(stat.getSubject().equals(resource)) {
                Resource predicate = stat.getPredicate();
                if(predicate.equals(L0.InstanceOf))
                    types.add(stat.getObject());
                else if(predicate.equals(L0.HasName))
                    name = stat.getObject();
                else if(predicate.equals(L0.HasLabel))
                    label = stat.getObject();
                else if(resource.equals(stat.getObject()))
                    tags.add(predicate);
                else if(g.isSubrelationOf(predicate, L0.HasNext) ||
                		g.isSubrelationOf(predicate, L0.HasPrevious))
                	;
                else
                    statements.add(stat);
            }
        }

        { // Compute labels
            ArrayList<String> labels = new ArrayList<String>(4);
            labels.add("$" + resource.getResourceId());
            if(name != null)
                labels.add((String)g.getValue(name, Bindings.STRING));
            if(label != null)
                labels.add((String)g.getValue(label, Bindings.STRING));
            for(Resource type : types)
                labels.add(": " + NameUtils.getSafeName(g, type));
            for(Resource tag : tags)
                labels.add("TAG " + NameUtils.getSafeName(g, tag));
            this.labels = labels.toArray(new String[labels.size()]);
        }
    }
    
    public Resource getResource() {
        return resource;
    }
    
    public ArrayList<Statement> getStatements() {
        return statements;
    }
    
    public void setStatements(ArrayList<Statement> statements) {
        this.statements = statements;
    }
}
