package org.simantics.debug.graphical;

import org.simantics.db.Resource;
import org.simantics.scl.runtime.function.Function;

/**
 * <code>Simantics/GraphicalDebugger</code> SCL API to avoid undesired AWT
 * toolkit initialization.
 * 
 * @author Tuukka Lehtonen
 */
public class DebuggerCanvasProxy {

    DebuggerCanvas canvas;

    public void setStatementFilter(@SuppressWarnings("rawtypes") Function statementFilter) {
        canvas.setStatementFilter(statementFilter);
    }

    public void removeStatementFilter() {
        canvas.removeStatementFilter();
    }

    public void addResource(Resource resource) {
        canvas.addResource(resource);
    }

    public DebuggerCanvasProxy(DebuggerCanvas canvas) {
        this.canvas = canvas;
    }

}
