/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.utils;

import java.util.Arrays;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.debug.browser.utils.ResourceInfo;

public class StatementInfo
implements Comparable<StatementInfo> {
    public final ResourceInfo subject;
    public final ResourceInfo object;
    public final ResourceInfo[] objectTypes;
    public final String graph;

    public StatementInfo(ReadGraph graph, Resource defaultSubject, Statement statement) throws DatabaseException {
        Resource subject = statement.getSubject();
        Resource predicate = statement.getPredicate();
        Resource object = statement.getObject();
        Collection objectTypes = graph.getPrincipalTypes(object);
        this.subject = subject.equalsResource(defaultSubject) ? null : new ResourceInfo(graph, subject);
        this.object = new ResourceInfo(graph, object);
        this.objectTypes = objectTypes.isEmpty() ? null : StatementInfo.mapTypes(graph, objectTypes);
        this.graph = StatementInfo.getGraphName(graph, subject, predicate, object);
    }

    private static ResourceInfo[] mapTypes(ReadGraph graph, Collection<Resource> types) throws DatabaseException {
        Object[] result = new ResourceInfo[types.size()];
        int i = 0;
        for (Resource type : types) {
            result[i++] = new ResourceInfo(graph, type);
        }
        Arrays.sort(result);
        return result;
    }

    public static String getGraphName(ReadGraph graph, Resource s, Resource p, Resource o) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getGraph(graph, s, p, o);
        if (vg != null) {
            return vg.toString();
        }
        return null;
    }

    @Override
    public int compareTo(StatementInfo o) {
        return this.object.compareTo(o.object);
    }
}

