/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.utils;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.utils.Escapes;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;

public class ResourceInfo
implements Comparable<ResourceInfo> {
    public final String label;
    public final String uri;
    public final long resourceId;
    public final Resource resource;

    public ResourceInfo(ReadGraph graph, Resource resource) throws DatabaseException {
        this.label = ResourceInfo.getLabel(graph, resource);
        this.uri = graph.getPossibleURI(resource);
        this.resourceId = resource.getResourceId();
        this.resource = resource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("<a href=\"").append(this.resourceId).append("\"");
        if (this.uri != null) {
            sb.append(" title=\"").append(this.uri).append("\"");
        }
        sb.append(">").append(Escapes.html(this.label)).append("</a>");
        return sb.toString();
    }

    public static String getLabel(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(resource, L0.HasName);
        if (name != null) {
            if (name.equals("Inverse")) {
                String parentName;
                Resource inverse = graph.getPossibleInverse(resource);
                Resource parent = graph.getPossibleObject(resource, L0.PartOf);
                if (inverse != null && inverse.equals(parent) && (parentName = (String)graph.getPossibleRelatedValue(parent, L0.HasName)) != null) {
                    return parentName + "/Inverse";
                }
            }
            return name;
        }
        if (graph.hasValue(resource)) {
            Datatype datatype = graph.getDataType(resource);
            Binding binding = Bindings.getBinding((Datatype)datatype);
            Object value = graph.getValue(resource, binding);
            try {
                String valueString = binding.toString(value, true);
                if (valueString.length() < 100) {
                    return valueString;
                }
                return valueString.substring(0, 100) + "...";
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
        }
        return "$" + resource.getResourceId();
    }

    @Override
    public int compareTo(ResourceInfo o) {
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)this.label, (Object)o.label);
    }
}

