/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.debug.browser.content.ResourceBrowserContent;

public class ResourceBrowserServlet
extends HttpServlet {
    private static final long serialVersionUID = -8253560202827865253L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=utf-8");
        response.setStatus(200);
        final PrintWriter writer = response.getWriter();
        try {
            Session session = Simantics.peekSession();
            if (session == null) {
                writer.write("<html><body>No database session.</body></html>");
                return;
            }
            String requestedResource = request.getPathInfo();
            if (requestedResource == null || requestedResource.equals("/")) {
                long rootId = session.getRootLibrary().getResourceId();
                response.sendRedirect("" + rootId);
                return;
            }
            final long resource = ResourceBrowserServlet.parseLong(requestedResource = requestedResource.substring(1));
            if (resource != 0L) {
                session.syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        ResourceBrowserContent content = (ResourceBrowserContent)graph.syncRequest((Read)new GetContent(resource));
                        content.toHtml(graph, writer);
                    }
                });
            } else {
                writer.write("<html><body>Resource not found: <em>");
                writer.write(requestedResource);
                writer.write("</em></body></html>");
            }
        }
        catch (Throwable e) {
            writer.write("<html><body>Problem occurred while reading <em>");
            writer.write(request.getPathInfo());
            writer.write("</em>:<br/><pre>");
            e.printStackTrace(writer);
            writer.write("</pre></body></html>");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Resource foundResource = null;
        Session session = Simantics.getSession();
        String input = request.getParameter("resource-input");
        if (input != null && !input.isEmpty()) {
            input = input.trim();
            SerialisationSupport support = (SerialisationSupport)session.getService(SerialisationSupport.class);
            if (input.startsWith("$")) {
                try {
                    foundResource = support.getResource(Long.parseLong(input.substring(1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (Exception exception) {}
            }
            if (foundResource == null) {
                String[] parts = input.split("-");
                if (parts.length == 1) {
                    try {
                        int resourceKey = Integer.parseInt(parts[0].trim());
                        foundResource = support.getResource(resourceKey);
                        ClusteringSupport cs = (ClusteringSupport)session.getService(ClusteringSupport.class);
                        long l = cs.getCluster(foundResource);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {}
                } else if (parts.length == 2) {
                    try {
                        int resourceIndex = Integer.parseInt(parts[1]);
                        long clusterId = Long.parseLong(parts[0]);
                        ClusteringSupport cs = (ClusteringSupport)session.getService(ClusteringSupport.class);
                        foundResource = cs.getResourceByIndexAndCluster(resourceIndex, clusterId);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {}
                }
            }
            if (foundResource == null) {
                try {
                    String uri = input;
                    if (!input.equals("http:/") && input.endsWith("/")) {
                        uri = input.substring(0, input.length() - 1);
                    }
                    new URI(uri);
                    foundResource = (Resource)session.syncRequest(Queries.resource((String)uri));
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                }
                catch (DatabaseException databaseException) {}
            }
        }
        if (foundResource != null) {
            response.sendRedirect("" + foundResource.getResourceId());
        } else {
            long rootId = session.getRootLibrary().getResourceId();
            response.sendRedirect("" + rootId);
        }
    }

    private static long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    static class GetContent
    extends UnaryRead<Long, ResourceBrowserContent> {
        public GetContent(long parameter) {
            super((Object)parameter);
        }

        public ResourceBrowserContent perform(ReadGraph graph) throws DatabaseException {
            Resource r = ((SerialisationSupport)graph.getService(SerialisationSupport.class)).getResource(((Long)this.parameter).longValue());
            return ResourceBrowserContent.createContentFor(graph, r);
        }
    }
}

