/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.sections;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.sections.ResourceBrowserSection;
import org.simantics.debug.browser.utils.ResourceInfo;
import org.simantics.debug.browser.utils.StatementInfo;
import org.simantics.layer0.Layer0;

public class RawStatementsSection
implements ResourceBrowserSection {
    public Resource resource;
    public THashMap<Resource, ArrayList<Statement>> statementsByPredicates = new THashMap();

    @Override
    public double getPriority() {
        return 100.0;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        THashMap predicateClassification = new THashMap();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Map.Entry entry : this.statementsByPredicates.entrySet()) {
            Resource domain = RawStatementsSection.getDomain(graph, L0, this.resource, (Resource)entry.getKey());
            THashMap map = (THashMap)predicateClassification.get((Object)domain);
            if (map == null) {
                map = new THashMap();
                predicateClassification.put((Object)domain, (Object)map);
            }
            map.put((Object)((Resource)entry.getKey()), (Object)((ArrayList)entry.getValue()));
        }
        ArrayList domains = new ArrayList(predicateClassification.keySet());
        Collections.sort(domains, new TypeComparator(graph, L0));
        for (Resource domain : domains) {
            out.println("<h2>" + String.valueOf(new ResourceInfo(graph, domain)) + "</h2>");
            this.generateStatementTable(graph, out, (THashMap<Resource, ArrayList<Statement>>)((THashMap)predicateClassification.get((Object)domain)));
        }
    }

    public void generateStatementTable(ReadGraph graph, PrintWriter out, THashMap<Resource, ArrayList<Statement>> statementsByPredicates) throws DatabaseException {
        ArrayList<ResourceInfo> predicateInfos = new ArrayList<ResourceInfo>(statementsByPredicates.size());
        for (Resource predicate : statementsByPredicates.keySet()) {
            predicateInfos.add(new ResourceInfo(graph, predicate));
        }
        Collections.sort(predicateInfos);
        if (!predicateInfos.isEmpty()) {
            out.println("<div id=\"rawStatementContent\">");
            out.println("<table>");
            out.println("<tr><th>Predicate</th><th>Object</th><th>Notes</th></tr>");
            for (ResourceInfo predicateInfo : predicateInfos) {
                ArrayList statements = (ArrayList)statementsByPredicates.get((Object)predicateInfo.resource);
                ArrayList<StatementInfo> statementInfos = new ArrayList<StatementInfo>(statements.size());
                for (Statement statement : statements) {
                    statementInfos.add(new StatementInfo(graph, this.resource, statement));
                }
                Collections.sort(statementInfos);
                boolean first = true;
                for (StatementInfo statementInfo : statementInfos) {
                    out.println("\t<tr>");
                    if (first) {
                        out.println("\t\t<td rowspan=\"" + statementInfos.size() + "\">" + String.valueOf(predicateInfo) + "</td>");
                        first = false;
                    }
                    out.print("\t\t<td");
                    if (statementInfo.subject != null) {
                        out.print(" class=\"asserted\"");
                    }
                    out.print(">" + String.valueOf(statementInfo.object));
                    if (statementInfo.objectTypes != null) {
                        out.print("<span class=\"resourceType\"> : ");
                        int i = 0;
                        while (i < statementInfo.objectTypes.length) {
                            if (i > 0) {
                                out.print(", ");
                            }
                            out.print(statementInfo.objectTypes[i]);
                            ++i;
                        }
                        out.print("</span>");
                    }
                    out.println("</td>");
                    if (statementInfo.graph != null || statementInfo.subject != null) {
                        out.print("\t\t<td>");
                        if (statementInfo.graph != null) {
                            out.print(" from graph " + statementInfo.graph);
                        }
                        if (statementInfo.subject != null) {
                            out.print(" from type " + String.valueOf(statementInfo.subject));
                        }
                        out.println("</td>");
                    }
                    out.println("\t</tr>");
                }
            }
            out.println("</table>");
            out.println("</div>");
        }
    }

    public static Resource getDomain(ReadGraph graph, Layer0 L0, Resource subject, Resource predicate) throws DatabaseException {
        Collection domains = graph.getObjects(predicate, L0.HasDomain);
        switch (domains.size()) {
            case 0: {
                return L0.Entity;
            }
            case 1: {
                return (Resource)domains.iterator().next();
            }
        }
        for (Resource domain : domains) {
            if (!graph.isInstanceOf(subject, domain)) continue;
            return domain;
        }
        return (Resource)domains.iterator().next();
    }

    private static class TypeComparator
    implements Comparator<Resource> {
        private final ReadGraph graph;
        private final Layer0 L0;
        private TObjectIntHashMap<Resource> depthCache = new TObjectIntHashMap();

        public TypeComparator(ReadGraph graph, Layer0 L0) {
            this.graph = graph;
            this.L0 = L0;
            this.depthCache.put((Object)L0.Entity, 0);
        }

        private int depth(Resource type) {
            if (this.depthCache.containsKey((Object)type)) {
                return this.depthCache.get((Object)type);
            }
            this.depthCache.put((Object)type, 0);
            try {
                int depth = 0;
                for (Resource superType : this.graph.getObjects(type, this.L0.Inherits)) {
                    depth = Math.max(depth, this.depth(superType));
                }
                this.depthCache.put((Object)type, ++depth);
                return depth;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return 0;
            }
        }

        @Override
        public int compare(Resource type1, Resource type2) {
            return Integer.compare(this.depth(type2), this.depth(type1));
        }
    }
}

