/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.internal.rewriters;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.RawStatementsSection;
import org.simantics.debug.browser.sections.TypeHierarchySection;
import org.simantics.debug.browser.utils.ResourceInfo;
import org.simantics.layer0.Layer0;

public enum TypeHierarchyCreator implements ResourceBrowserRewriter
{
    INSTANCE;


    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content) throws DatabaseException {
        content.putSection(TypeHierarchySection.class, new TypeHierarchySection(new TypeHierarchySection.Node(null, null, this.getSuper(graph, content.resource))));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        RawStatementsSection rawStatementsSection = content.getSection(RawStatementsSection.class);
        rawStatementsSection.statementsByPredicates.remove((Object)L0.InstanceOf);
        rawStatementsSection.statementsByPredicates.remove((Object)L0.SubrelationOf);
        rawStatementsSection.statementsByPredicates.remove((Object)L0.Inherits);
    }

    public TypeHierarchySection.Node[] getSuper(ReadGraph graph, Resource resource) throws DatabaseException {
        ArrayList<TypeHierarchySection.Node> nodes = new ArrayList<TypeHierarchySection.Node>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource s : graph.getObjects(resource, L0.InstanceOf)) {
            nodes.add(new TypeHierarchySection.Node(":", new ResourceInfo(graph, s), this.getSuper(graph, s)));
        }
        for (Resource s : graph.getObjects(resource, L0.Inherits)) {
            if (s.equals(L0.Entity)) continue;
            nodes.add(new TypeHierarchySection.Node("&lt;T", new ResourceInfo(graph, s), this.getSuper(graph, s)));
        }
        for (Resource s : graph.getObjects(resource, L0.SubrelationOf)) {
            if (s.equals(L0.IsWeaklyRelatedTo)) continue;
            nodes.add(new TypeHierarchySection.Node("&lt;R", new ResourceInfo(graph, s), this.getSuper(graph, s)));
        }
        return nodes.toArray(new TypeHierarchySection.Node[nodes.size()]);
    }

    @Override
    public double getPriority() {
        return 1.0;
    }
}

