/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.utils.Escapes;

public class BreadcrumbSection implements ResourceBrowserSection {

    public final Node[] breadcrumb;
    
    public BreadcrumbSection(Node[] breadcrumb) {
        this.breadcrumb = breadcrumb;
    }

    public static class Node {
        public final String separator;
        public final String name;
        public final long resourceId;
        
        public Node(String separator, String name, long resourceId) {
            this.separator = separator;
            this.name = name;
            this.resourceId = resourceId;
        }
    }
    
    @Override
    public double getPriority() {
        return 0;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out)
            throws DatabaseException {
        
        if (breadcrumb.length > 0) {
            out.println("<div class=\"breadcrumbSection\">");
            for(Node node : breadcrumb) {
                out.print(node.separator);
                out.print("<a href=\"");
                out.print(node.resourceId);
                out.print("\">");
                out.print(Escapes.html(node.name));
                out.print("</a>");
            }
            out.println("</div>");
        }
    }

}
