/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Hashtable;

import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.internal.rewriters.BreadcrumbCreator;
import org.simantics.debug.browser.internal.rewriters.PageHeaderCreator;
import org.simantics.debug.browser.internal.rewriters.RawStatementsCreator;
import org.simantics.debug.browser.internal.rewriters.ResourceInfoCreator;
import org.simantics.debug.browser.internal.rewriters.ResourceLookupCreator;
import org.simantics.debug.browser.internal.rewriters.TypeHierarchyCreator;

public class Activator implements BundleActivator {

    public static final String PLUGIN_ID = "org.simantics.debug.browser";
    private static BundleContext context;
    private static Activator plugin;
    private static String resourcesPath;
    private DebugBrowserServer server;

    /*
     * (non-Javadoc)
     * 
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.
     * BundleContext)
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    public void start(BundleContext bundleContext) throws Exception {
        Activator.context = bundleContext;
        plugin = this;

        Hashtable properties = new Hashtable();
        bundleContext.registerService(ResourceBrowserRewriter.class, PageHeaderCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, ResourceLookupCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, RawStatementsCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, BreadcrumbCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, TypeHierarchyCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, ResourceInfoCreator.INSTANCE, properties);

        URL url = context.getBundle().getEntry("resources");
        URL fileURL = FileLocator.toFileURL(url);
        File filePath = new File(URLDecoder.decode(fileURL.getPath(), "UTF-8"));
        resourcesPath = filePath.getCanonicalPath();
    }

    public DebugBrowserServer getDebugServer() {
        return server;
    }

    public synchronized DebugBrowserServer startDebugServer() throws Exception {
        if (server == null) {
            server = new DebugBrowserServer(resourcesPath);
            server.start();
        }
        return server;
    }

    public synchronized void stopDebugServer() throws Exception {
        if (server != null) {
            server.stop();
        }
        server = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext bundleContext) throws Exception {
        stopDebugServer();
        Activator.context = null;
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

}
