/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.function;

import java.util.Objects;
import org.simantics.db.exception.DatabaseException;

@FunctionalInterface
public interface DbPredicate<T> {
    public boolean test(T var1) throws DatabaseException;

    default public DbPredicate<T> and(DbPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public DbPredicate<T> negate() {
        return t -> !this.test(t);
    }

    default public DbPredicate<T> or(DbPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> DbPredicate<T> isEqual(Object targetRef) {
        return targetRef == null ? Objects::isNull : object2 -> targetRef.equals(object2);
    }
}

