package org.simantics.db.testing.impl;
/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/


import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;


public class Proxy {

	private static int PORT = 6668;
	private static String SERVER_ADDRESS="localhost:6666";
	private boolean interrupted = false;
	
	public Proxy() {
	}
	
	public void run() {
		ServerSocket service = null;
		try {
			service = new ServerSocket(PORT);
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		
		System.out.println("Accepting connections");
		
        int connectionNumber = 0;
		while(!interrupted) {
			try {
				final Socket socket = service.accept();
				String connectionName = "Connection" + ++connectionNumber;
				System.out.println(connectionName + ": Client connection accepted.");
				Runnable runnable = new Runnable() {
					@Override
					public void run() {
						try {
							serve(socket);
							socket.close();
						} catch(IOException e) {
							e.printStackTrace();
						}
					}
				};
				Thread t = new Thread(runnable, connectionName);
				t.start();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		// Shutdown service
		try {
			if(service != null)
				service.close();
		} catch (IOException ignore) {
		}
	}
	
	/**
	 * Serves socket connection.
	 * 
	 * @param socket
	 * @throws IOException
	 */
    private void serve(Socket socket) throws IOException {
        String[] split = SERVER_ADDRESS.split(":");
        if (split.length != 2)
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");

        InetSocketAddress dbAddress =  new InetSocketAddress(split[0], Integer.parseInt(split[1]));
        Socket dbSocket = new Socket();
        try {
            dbSocket.connect(dbAddress);
        } catch(IOException e) {
            dbSocket.close();
            System.out.println("serve() Couldn't connect to database '" + SERVER_ADDRESS +"'");
            return;
        }
        String t = Thread.currentThread().getName();
        System.out.println(t + ": Server connection ok.");
        proxy(dbSocket, socket, "db",  "client");
        dbSocket.close();
        System.out.println(t + ": Client connection closed.");
    }
	
	/**
	 * Proxies data from socket a to socket b and vice versa
	 * This method blocks until one of the sockets closes or exception is thrown.
	 * 
	 * @param a
	 * @param b
	 */
	private void proxy(final Socket a, final Socket b, final String aName, final String bName) {		
		// A -> B
		Runnable ab = new Runnable() {
			@Override
			public void run() {
				try {
                    byte buffer[] = new byte[256];
					while(a.isConnected() && b.isConnected()) {
						int n = a.getInputStream().read(buffer);
						if (n < 1)
						    break;
						b.getOutputStream().write(buffer, 0, n);
						b.getOutputStream().flush();
					}
				} catch(IOException e) {
					return; // for debugging
				}
			}
		};
		
		// B -> A
		Runnable ba = new Runnable() {
			@Override
			public void run() {
				try {
                    byte buffer[] = new byte[256];
					while(b.isConnected() && a.isConnected()) {
						int n = b.getInputStream().read(buffer);
                        if (n < 1)
                            break;
						a.getOutputStream().write(buffer, 0, n);
						a.getOutputStream().flush();
					}
				} catch(IOException e) {
				    return; // for debugging
				}				
			}
		};
		String t = Thread.currentThread().getName();
		Thread tab = new Thread(ab, t + " " + aName + "->" + bName);
		Thread tba = new Thread(ba, t + " " + bName + "->" + aName);
		
		tab.start();
		tba.start();
		
		try {
			while(tba.isAlive() && tab.isAlive()) {
				Thread.sleep(1000);
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		try {
			a.close();
			b.close();
		} catch (IOException e) {
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Proxy proxy = new Proxy();
		proxy.run();
	}

}
