package org.simantics.db.testing.impl;


import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.testing.common.Tests;

public class BaseClient {
    protected static final boolean DEBUG = false;
//    protected static final String HOST = Configuration.get().host;
//    protected final int PORT = Configuration.get().port;
//    protected static final  String USERNAME = Configuration.get().username;
//    protected static final String PASSWORD = Configuration.get().password;
//    protected Driver driver;
    protected Session session;
    protected final String random;
    public BaseClient(String name)
    throws DatabaseException {
        random = name;
        session = Tests.getTestHandler().getSession();
    }
    public void close() throws DatabaseException {
        try {
            if (null != session) {
                LifecycleSupport ls = session.getService(LifecycleSupport.class);
                ls.close();
            }
        } finally {
            session = null;
        }
    }
    public Session getSession() {
        return session;
    }
}