package org.simantics.db.testing.common;

import java.io.File;

public class TestSettings {

	private static TestSettings INSTANCE = new TestSettings();
	
	private String[] adapters = new String[0];
	private String[] ontologies = new String[0];
	private File workspace;
	
	private boolean initialized = false;
	
	private TestSettings() {
	}

	public static TestSettings getInstance() {
		if(!INSTANCE.initialized) throw new IllegalStateException("POJO settings have not been defined. Please run a suitable configuration test.");
		return INSTANCE;
	}
	
	public void setInitialized() {
		initialized = true;
	}
	
	public static void setInstance(TestSettings settings) {
		INSTANCE = settings;
	}
	
	public String[] getAdapters() {
		return adapters;
	}
	
	public void setAdapters(String[] adapters) {
		this.adapters = adapters;
	}
	
	public String[] getOntologies() {
		return ontologies;
	}
	
	public void setOntologies(String[] ontologies) {
		this.ontologies = ontologies;
	}

	public File getWorkspace() {
		return workspace;
	}
	
	public void setWorkspace(File workspace) {
		this.workspace = workspace;
	}
	
	/*
	 * Only for initialization purposes.
	 */
	public static TestSettings getInstanceUnsafe() {
		return INSTANCE;
	}
	
}
