/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption.reflection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;

public class ConstantAdapter implements IDynamicAdapter2 {

	Object obj;
	Class<?> clazz;

    public ConstantAdapter(Class<?> clazz, Object obj) {
        this.clazz = clazz;
        this.obj = obj;
    }
    
    public ConstantAdapter(Object obj) {
        this(obj.getClass(), obj);
    }

    @Override
	public Class<?> getType() {
		return clazz;
	}

	@Override
	public Object adapt(ReadGraph g, Resource r) {
	    return obj;
	}

}
