/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.services.adaption.reflection;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;

public class AdaptingDynamicAdapter2 implements IDynamicAdapter2 {

    IDynamicAdapter2 adapter;
    Class<?> targetType;

    public AdaptingDynamicAdapter2(IDynamicAdapter2 adapter, Class<?> targetType) {
        this.adapter = adapter;
        this.targetType = targetType;
    }

    @Override
    public Object adapt(ReadGraph g, Resource r) throws DatabaseException {
        Object obj = adapter.adapt(g, r);
        if(obj == null)
            return null;
        if(obj instanceof Resource)
            return g.adapt((Resource)obj, targetType);
        if(obj instanceof Collection<?>) {
            Collection<?> c = (Collection<?>)obj;
            Collection<Object> ret = new ArrayList<Object>(c.size());
            for(Object o : c)
                ret.add(g.adapt((Resource)o, targetType));
            return ret;
        }
        throw new AdaptionException("Invalid type.");
    }

    @Override
    public Class<?> getType() throws DatabaseException {
        if(adapter.getType().equals(Resource.class))
            return targetType;
        else if(adapter.getType().equals(Collection.class))
            return Collection.class;
        else
            throw new AdaptionException("Invalid type.");
    }

}
