/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

public abstract class AbstractMessage extends Message {
	protected final int requestNumber;
	protected final int responseNumber;
	protected int receivedNumber = 0;
	protected boolean responsePending = false;
	protected DataBuffer buffer;
	private String exceptionText = null;
	AbstractMessage(int requestNumber, int responseNumber) {
		this.requestNumber = requestNumber;
		this.responseNumber = responseNumber;
		this.buffer = new DataBuffer(DataBuffer.Allocation.DirectAllocation); //ByteBuffer.allocate(0);
	}
	AbstractMessage(int requestNumber, int responseNumber, DataBuffer buffer) {
		this.requestNumber = requestNumber;
		this.responseNumber = responseNumber;
		this.buffer = buffer;
	}
    public int getRequestNumber() {
        return requestNumber;
    }
    public int getResponseNumber() {
        return responseNumber;
    }
	@Override
	boolean hasResponse() {
		return responseNumber != 0;
	}
	@Override
	String getExceptionText() {
		return this.exceptionText;
	}
	@Override
	void setExceptionText(String text) {
		this.exceptionText = text;
	}
    void gotResponse() {
    	responsePending = false;
    }
}
