/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.procore.cluster.CalculateStatements;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ObjectTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CalculateStatementsSmall
implements ClusterI.PredicateProcedure<CalculateStatements> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateStatementsSmall.class);
    private ObjectTable ot;
    private final int sRef;

    CalculateStatementsSmall(int sRef, ObjectTable ot) {
        this.sRef = sRef;
        this.ot = ot;
    }

    public boolean execute(CalculateStatements context, int pKey, int oIndex) {
        if (ClusterTraits.statementIndexIsDirect(oIndex)) {
            return false;
        }
        try {
            oIndex = ClusterTraits.statementIndexGet(oIndex);
        }
        catch (DatabaseException e) {
            LOGGER.error("Missing object set for s=" + this.sRef + " p=" + pKey, (Throwable)e);
            return false;
        }
        int osize = this.ot.getObjectSetSize(oIndex);
        if (osize == 3 || osize > 9) {
            System.out.println("Resource " + this.sRef + " predicate " + pKey + " has " + osize + " objects.");
        }
        return true;
    }
}

