/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.SessionManagerSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.simantics.db.Database;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.auth.UserAuthenticators;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.SDBException;
import org.simantics.db.procore.ProCoreManagement;
import org.simantics.db.procore.ProCoreServer;
import org.simantics.db.server.DatabaseManager;
import org.simantics.db.server.ProCoreException;

public class ProCoreDriver
implements Driver {
    private static long sessionId = -1L;
    public static final String ProCoreDriverName = "procore";
    public static final String ProCoreDriverNameVirtual = "virtual";

    public final String getName() {
        return ProCoreDriverName;
    }

    public DatabaseUserAgent getDatabaseUserAgent(String address) throws DatabaseException {
        Path dbFolder = Paths.get(address, new String[0]);
        return DatabaseManager.getDatabase((Path)dbFolder).getUserAgent();
    }

    public void setDatabaseUserAgent(String address, DatabaseUserAgent dbUserAgent) throws DatabaseException {
        Path dbFolder = Paths.get(address, new String[0]);
        DatabaseManager.getDatabase((Path)dbFolder).setUserAgent(dbUserAgent);
    }

    public Session getSession(String address, Properties properties) throws SDBException {
        Path dbFolder = Paths.get(address, new String[0]);
        if (!Files.isDirectory(dbFolder, new LinkOption[0])) {
            throw new ProCoreException("Database folder does not exist. folder=" + String.valueOf(dbFolder));
        }
        Database db = DatabaseManager.getDatabase((Path)dbFolder);
        if (!db.isFolderOk()) {
            throw new ProCoreException("Database folder is not ok. folder=" + String.valueOf(dbFolder));
        }
        if (!db.isRunning()) {
            db.start();
        }
        if (!db.isConnected()) {
            db.connect();
        }
        ProCoreServerReference serverReference = new ProCoreServerReference(dbFolder);
        ProCoreSessionReference sessionReference = new ProCoreSessionReference(serverReference, ++sessionId);
        try {
            String user = properties.getProperty("user");
            String password = properties.getProperty("password");
            if (user == null) {
                throw new ProCoreException("'user' property not provided");
            }
            if (password == null) {
                throw new ProCoreException("'password' property not provided");
            }
            UserAuthenticator authenticator = UserAuthenticators.byNameAndPassword((String)user, (String)password);
            if (properties.getProperty("hyshys") != null) {
                authenticator = new BackdoorAuthenticator();
            }
            UserAuthenticationAgent agent = UserAuthenticationAgents.staticAgent((UserAuthenticator)authenticator);
            Session session = SessionManagerSource.getSessionManager().createSession((SessionReference)sessionReference, agent);
            if (!properties.containsKey("clientId")) {
                properties.put("clientId", dbFolder.toFile().getAbsolutePath());
            }
            session.registerService(Properties.class, (Object)properties);
            Session s = (Session)session.peekService(Session.class);
            if (s == null) {
                session.registerService(Session.class, (Object)session);
            }
            return session;
        }
        catch (IOException e) {
            throw new ProCoreException("Connect failed. address=" + serverReference.toString(), (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new ProCoreException("Connect failed. address=" + serverReference.toString(), (Throwable)e);
        }
    }

    public ServerI getServer(String address, Properties notUsed) throws ProCoreException {
        Path dbFolder = Paths.get(address, new String[0]);
        return new ProCoreServer(dbFolder.toFile());
    }

    public Driver.Management getManagement(String address, Properties properties) throws DatabaseException {
        Path dbFolder = Paths.get(address, new String[0]);
        return new ProCoreManagement(dbFolder, properties);
    }
}

