/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.DirectStatementsImpl;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.ObjectResourceMap;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SessionRequestManager;
import fi.vtt.simantics.procore.internal.State;
import fi.vtt.simantics.procore.internal.VirtualGraphServerSupportImpl;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.function.Consumer;
import org.simantics.db.DirectStatements;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.support.BuiltinSupport;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.request.Write;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySupportImpl
implements QuerySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySupportImpl.class);
    final SessionImplSocket session;
    final State state;
    final ClusterTable clusterTable;
    final BuiltinSupport builtinSupport;
    final ClusterSupport clusterSupport;
    final ResourceSupport resourceSupport;
    final SerialisationSupport serializationSupport;
    final VirtualGraphServerSupportImpl virtualGraphServerSupport;
    final GraphSession graphSession;
    final SessionRequestManager syncThreads;
    final int root;
    private boolean pendingPrimitives = false;

    QuerySupportImpl(SessionImplSocket session, ClusterSupport clusterSupport, SerialisationSupport serializationSupport, SessionRequestManager syncThreads) {
        this.session = session;
        this.state = session.state;
        this.clusterTable = session.clusterTable;
        this.resourceSupport = session.resourceSupport;
        this.virtualGraphServerSupport = session.virtualGraphServerSupport;
        this.graphSession = session.graphSession;
        this.builtinSupport = session.builtinSupport;
        this.clusterSupport = clusterSupport;
        this.serializationSupport = serializationSupport;
        this.syncThreads = syncThreads;
        this.root = this.getBuiltin("http:/");
        assert (this.session != null);
        assert (this.state != null);
        assert (this.clusterTable != null);
        assert (this.resourceSupport != null);
        assert (this.virtualGraphServerSupport != null);
        assert (this.graphSession != null);
        assert (this.builtinSupport != null);
        assert (this.clusterSupport != null);
        assert (this.serializationSupport != null);
        assert (this.syncThreads != null);
    }

    public ResourceSupport getSupport() {
        return this.resourceSupport;
    }

    public ClusterSupport getClusterSupport() {
        return this.clusterSupport;
    }

    public ObjectResourceIdMap<String> createChildMap() {
        return new ObjectResourceMap<String>(this.session);
    }

    public Statement getStatement(int s, int p, int o) {
        return this.getStatement(null, s, p, o);
    }

    public Statement getStatement(ReadGraphImpl graph, int s, int p, int o) {
        Resource sr = this.getResource(s);
        Resource pr = this.getResource(p);
        Resource or = this.getResource(o);
        return new StandardStatement(sr, pr, or);
    }

    public Session getSession() {
        return this.session;
    }

    public long getClusterId(int id) {
        Object cluster = this.clusterTable.getClusterByResourceKey(id);
        if (cluster == null) {
            return 0L;
        }
        return cluster.getClusterId();
    }

    public boolean isImmutable(int id, boolean checkServiceMode) {
        if (id < 0) {
            return false;
        }
        if (this.root == id) {
            return false;
        }
        if (checkServiceMode && this.session.serviceMode > 0) {
            return false;
        }
        return this.clusterTable.isImmutable(id);
    }

    public int getId(Resource resource) {
        if (resource instanceof ResourceImpl) {
            return ((ResourceImpl)resource).id;
        }
        return 0;
    }

    public Resource getResource(int id) {
        try {
            return this.serializationSupport.getResource(id);
        }
        catch (DatabaseException e) {
            LOGGER.error("getResource(" + id + ") failed", (Throwable)e);
            return null;
        }
    }

    public void dirtyPrimitives() {
        this.session.dirtyPrimitives = true;
        if (this.state.getWriteCount() == 0 && !this.pendingPrimitives) {
            this.pendingPrimitives = true;
            this.session.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    QuerySupportImpl.this.pendingPrimitives = false;
                }
            });
        }
    }

    @Deprecated
    public final void aboutToRead() {
    }

    public void getObjects4(ReadGraphImpl graph, int subject, ForEachObjectProcedure procedure) {
        if (subject < 0) {
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, procedure.predicateKey);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    try {
                        procedure.execute((ReadGraph)graph, (Resource)new ResourceImpl(this.resourceSupport, id));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected exception while handling object", (Throwable)e);
                    }
                    ++n2;
                }
            }
            try {
                procedure.finished((ReadGraph)graph);
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
            }
            return;
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            try {
                cluster.load();
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
            }
            this.getObjects4(graph, subject, procedure);
            return;
        }
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject)) {
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, procedure.predicateKey);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    try {
                        procedure.execute((ReadGraph)graph, (Resource)new ResourceImpl(this.resourceSupport, id));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
                    }
                    ++n3;
                }
            }
            try {
                cluster.forObjects(graph, subject, procedure);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        } else {
            try {
                cluster.forObjects(graph, subject, procedure);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    public <C> void getObjects4(final ReadGraphImpl graph, final int subject, final C context, final ForEachObjectContextProcedure<C> procedure) {
        if (subject < 0) {
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, procedure.predicateKey);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    try {
                        procedure.execute((ReadGraph)graph, context, (Resource)new ResourceImpl(this.resourceSupport, id));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
                    }
                    ++n2;
                }
            }
            try {
                procedure.finished((ReadGraph)graph, context);
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
            }
            return;
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    QuerySupportImpl.this.getObjects4(graph, subject, context, procedure);
                }
            });
            return;
        }
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject)) {
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, procedure.predicateKey);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    try {
                        procedure.execute((ReadGraph)graph, context, (Resource)new ResourceImpl(this.resourceSupport, id));
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Unexpected exception while handling objects", (Throwable)e);
                    }
                    ++n3;
                }
            }
            try {
                cluster.forObjects(graph, subject, context, procedure);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        } else {
            try {
                cluster.forObjects(graph, subject, context, procedure);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    public int getSingleInstance(int subject) {
        if (subject < 0) {
            return 0;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        if (cluster == null) {
            System.out.println("null cluster: " + Integer.toString(subject, 16));
        }
        assert (cluster != null);
        try {
            ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subject, this.clusterSupport);
            if (ClusterI.CompleteTypeEnum.InstanceOf == type) {
                int result = cluster.getCompleteObjectKey(subject, this.clusterSupport);
                assert (result > 0);
                return result;
            }
            return 0;
        }
        catch (DatabaseException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            return 0;
        }
        catch (Throwable t) {
            this.analyseProblem((ClusterI)cluster);
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            return 0;
        }
    }

    public int getSingleSuperrelation(int subject) {
        if (subject < 0) {
            return 0;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        if (cluster == null) {
            System.out.println("null cluster: " + Integer.toString(subject, 16));
        }
        assert (cluster != null);
        try {
            ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subject, this.clusterSupport);
            if (ClusterI.CompleteTypeEnum.SubrelationOf == type) {
                int result = cluster.getCompleteObjectKey(subject, this.clusterSupport);
                assert (result > 0);
                return result;
            }
            return 0;
        }
        catch (DatabaseException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            return 0;
        }
    }

    public boolean getObjects(final ReadGraphImpl graph, int subject, int predicate, final IntProcedure procedure) throws DatabaseException {
        assert (subject != 0);
        assert (predicate != 0);
        if (subject < 0) {
            boolean found = false;
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    found = true;
                    procedure.execute(graph, id);
                    ++n2;
                }
            }
            return found;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        assert (cluster.isLoaded());
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject)) {
            final DataContainer found = new DataContainer((Object)Boolean.FALSE);
            final TIntHashSet result = new TIntHashSet(5);
            for (TransientGraph g : this.virtualGraphServerSupport.providers) {
                int[] nArray = g.getObjects(subject, predicate);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    found.set((Object)true);
                    if (result.add(id)) {
                        procedure.execute(graph, id);
                    }
                    ++n3;
                }
            }
            if (predicate < 0) {
                return (Boolean)found.get();
            }
            ClusterI.ObjectProcedure<Object> proc = new ClusterI.ObjectProcedure<Object>(){

                public boolean execute(Object context, int object) {
                    found.set((Object)true);
                    if (result.add(object)) {
                        try {
                            procedure.execute(graph, object);
                        }
                        catch (DatabaseException e) {
                            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                        }
                    }
                    return false;
                }
            };
            try {
                cluster.forObjects(subject, predicate, (ClusterI.ObjectProcedure)proc, null, this.clusterSupport);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            return (Boolean)found.get();
        }
        if (predicate < 0) {
            return false;
        }
        class A
        implements ClusterI.ObjectProcedure<Object> {
            boolean found = false;
            private final /* synthetic */ IntProcedure val$procedure;
            private final /* synthetic */ ReadGraphImpl val$graph;

            A(IntProcedure intProcedure, ReadGraphImpl readGraphImpl) {
                this.val$procedure = intProcedure;
                this.val$graph = readGraphImpl;
            }

            public boolean execute(Object context, int object) {
                this.found = true;
                try {
                    this.val$procedure.execute(this.val$graph, object);
                }
                catch (DatabaseException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                }
                return false;
            }

            public boolean found() {
                return this.found;
            }
        }
        A proc = new A(procedure, graph);
        try {
            cluster.forObjects(subject, predicate, (ClusterI.ObjectProcedure)proc, null, this.clusterSupport);
        }
        catch (DatabaseException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
        }
        catch (Throwable t) {
            this.analyseProblem((ClusterI)cluster);
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
        }
        return proc.found();
    }

    public int getFunctionalObject(int subject, int predicate) {
        assert (subject != 0);
        assert (predicate != 0);
        if (subject < 0) {
            int found = 0;
            Collection<TransientGraph> providers = this.virtualGraphServerSupport.getVirtualGraphs(subject);
            if (providers != null) {
                for (VirtualGraph virtualGraph : providers) {
                    int[] nArray = ((VirtualGraphImpl)virtualGraph).getObjects(subject, predicate);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        found = found == 0 ? id : -1;
                        ++n2;
                    }
                }
            }
            return found;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject)) {
            int result = 0;
            Collection<TransientGraph> collection = this.virtualGraphServerSupport.getVirtualGraphs(subject);
            if (collection != null) {
                for (VirtualGraph virtualGraph : collection) {
                    int[] nArray = ((VirtualGraphImpl)virtualGraph).getObjects(subject, predicate);
                    int n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        result = result == 0 ? id : -1;
                        ++n3;
                    }
                }
            }
            if (result != 0) {
                return result;
            }
            try {
                return cluster.getSingleObject(subject, predicate, this.clusterSupport);
            }
            catch (DatabaseException databaseException) {
                return -1;
            }
        }
        try {
            return cluster.getSingleObject(subject, predicate, this.clusterSupport);
        }
        catch (DatabaseException databaseException) {
            return -1;
        }
        catch (Throwable t) {
            this.analyseProblem((ClusterI)cluster);
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
            return -1;
        }
    }

    public DirectStatements getStatements(ReadGraphImpl graph, int subject, QueryProcessor processor, boolean ignoreVirtual) {
        Collection<TransientGraph> providers;
        assert (subject != 0);
        DirectStatementsImpl result = new DirectStatementsImpl(this.resourceSupport, subject);
        if (!ignoreVirtual && (providers = this.virtualGraphServerSupport.getVirtualGraphs(subject)) != null) {
            for (TransientGraph provider : providers) {
                int[] nArray = provider.getPredicates(subject);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int p = nArray[n2];
                    int[] nArray2 = provider.getObjects(subject, p);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int o = nArray2[n4];
                        result.addStatement(p, o);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (subject < 0) {
            return result;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        assert (cluster != null);
        this.doGetStatements(graph, (ClusterI)cluster, subject, result);
        return result;
    }

    public void getPredicates(final ReadGraphImpl graph, int subject, final IntProcedure procedure) throws DatabaseException {
        final TIntHashSet result = new TIntHashSet(16);
        Collection<TransientGraph> providers = this.virtualGraphServerSupport.getVirtualGraphs(subject);
        if (providers != null) {
            for (VirtualGraph virtualGraph : providers) {
                int[] nArray = ((VirtualGraphImpl)virtualGraph).getPredicates(subject);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (result.add(id)) {
                        procedure.execute(graph, id);
                    }
                    ++n2;
                }
            }
        }
        if (subject < 0) {
            procedure.finished(graph);
            return;
        }
        Object t = this.clusterTable.getClusterByResourceKey(subject);
        assert (t != null);
        final DataContainer got = new DataContainer((Object)0);
        ClusterI.PredicateProcedure<Object> proc = new ClusterI.PredicateProcedure<Object>(){

            public boolean execute(Object context, int predicate, int oi) {
                if (result.add(predicate)) {
                    try {
                        procedure.execute(graph, predicate);
                    }
                    catch (DatabaseException e) {
                        org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    }
                }
                got.set((Object)((Integer)got.get() + 1));
                return false;
            }
        };
        try {
            try {
                t.forPredicates(subject, (ClusterI.PredicateProcedure)proc, null, this.clusterSupport);
            }
            catch (DatabaseException e) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                procedure.finished(graph);
            }
            catch (RuntimeException e) {
                throw new DatabaseException("Fatal error while trying to get predicates from database", (Throwable)e);
            }
        }
        finally {
            procedure.finished(graph);
        }
    }

    public byte[] getValue(ReadGraphImpl graph, int resource) throws DatabaseException {
        if (resource < 0) {
            Collection<TransientGraph> providers = this.virtualGraphServerSupport.getVirtualGraphs(resource);
            if (providers != null) {
                for (VirtualGraph virtualGraph : providers) {
                    byte[] value = ((VirtualGraphImpl)virtualGraph).getValue(resource);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(resource);
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(resource)) {
            Collection<TransientGraph> collection = this.virtualGraphServerSupport.getVirtualGraphs(resource);
            if (collection != null) {
                for (VirtualGraph virtualGraph : collection) {
                    byte[] value = ((VirtualGraphImpl)virtualGraph).getValue(resource);
                    if (value == null) continue;
                    return value;
                }
            }
            try {
                byte[] byArray = cluster.getValue(resource, this.clusterSupport);
                if (byArray != null && byArray.length != 0) {
                    return byArray;
                }
            }
            catch (DatabaseException databaseException) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)databaseException);
            }
            catch (RuntimeException runtimeException) {
                throw new DatabaseException("Fatal error while trying to get value from database", (Throwable)runtimeException);
            }
            return null;
        }
        try {
            byte[] byArray = cluster.getValue(resource, this.clusterSupport);
            if (byArray != null && byArray.length != 0) {
                return byArray;
            }
        }
        catch (DatabaseException databaseException) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)databaseException);
        }
        catch (RuntimeException runtimeException) {
            throw new DatabaseException("Fatal error while trying to get value from database", (Throwable)runtimeException);
        }
        return null;
    }

    public InputStream getValueStream(ReadGraphImpl graph, int resource) {
        if (resource < 0) {
            Collection<TransientGraph> providers = this.virtualGraphServerSupport.getVirtualGraphs(resource);
            if (providers != null) {
                for (VirtualGraph virtualGraph : providers) {
                    byte[] value = ((VirtualGraphImpl)virtualGraph).getValue(resource);
                    if (value == null) continue;
                    return new ByteArrayInputStream(value);
                }
            }
            return null;
        }
        Object cluster = this.clusterTable.getClusterByResourceKey(resource);
        if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(resource)) {
            Collection<TransientGraph> collection = this.virtualGraphServerSupport.getVirtualGraphs(resource);
            if (collection != null) {
                for (VirtualGraph virtualGraph : collection) {
                    byte[] value = ((VirtualGraphImpl)virtualGraph).getValue(resource);
                    if (value == null) continue;
                    return new ByteArrayInputStream(value);
                }
            }
            try {
                return cluster.getValueStream(resource, this.clusterSupport);
            }
            catch (DatabaseException databaseException) {
                org.simantics.db.common.utils.Logger.defaultLogError((Throwable)databaseException);
                return null;
            }
        }
        try {
            return cluster.getValueStream(resource, this.clusterSupport);
        }
        catch (DatabaseException databaseException) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)databaseException);
            return null;
        }
    }

    public void requestCluster(ReadGraphImpl graph, long clusterId, Runnable r) {
        double p = this.clusterTable.getLoadProbability();
        ClusterBase proxy = this.clusterSupport.getClusterByClusterId(clusterId);
        if (!proxy.isLoaded()) {
            this.clusterTable.gc();
            if (Math.random() < p) {
                class CallbackAdapter
                implements Consumer<DatabaseException> {
                    final Runnable r;

                    CallbackAdapter(Runnable r) {
                        this.r = r;
                    }

                    @Override
                    public void accept(DatabaseException e) {
                        if (e != null) {
                            e.printStackTrace();
                        } else {
                            this.r.run();
                        }
                    }
                }
                proxy.load((Consumer)new CallbackAdapter(r));
            } else {
                r.run();
            }
        } else {
            r.run();
        }
    }

    public int getBuiltin(String uri) {
        return this.builtinSupport.getBuiltin(uri);
    }

    public void checkTasks() {
        System.out.println(this.syncThreads.toString());
    }

    private void doGetStatements(ReadGraphImpl graph, ClusterI cluster, int subject, DirectStatementsImpl result) {
        try {
            final class Proc
            implements ClusterI.PredicateProcedure<Object> {
                private final /* synthetic */ ClusterI val$cluster;
                private final /* synthetic */ int val$subject;
                private final /* synthetic */ DirectStatementsImpl val$result;

                Proc(ClusterI clusterI, int n, DirectStatementsImpl directStatementsImpl) {
                    this.val$cluster = clusterI;
                    this.val$subject = n;
                    this.val$result = directStatementsImpl;
                }

                public boolean execute(Object context, int predicate, int objectIndex) {
                    this.doExecute(null, predicate, objectIndex);
                    return false;
                }

                private void doExecute(Object context, final int predicate, int objectIndex) {
                    try {
                        this.val$cluster.forObjects(this.val$subject, predicate, (ClusterI.ObjectProcedure)new ClusterI.ObjectProcedure<Object>(){

                            public boolean execute(Object context, int object) {
                                val$result.addStatement(predicate, object);
                                return false;
                            }
                        }, null, QuerySupportImpl.this.clusterSupport);
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                }
            }
            cluster.forPredicates(subject, (ClusterI.PredicateProcedure)new Proc(cluster, subject, result), null, this.clusterSupport);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    long getCluster(int id) {
        if (id < 0) {
            return 0L;
        }
        Object proxy = this.clusterTable.getClusterByResourceKey(id);
        if (proxy == null) {
            return 0L;
        }
        return proxy.getClusterId();
    }

    public int getRandomAccessReference(String id) throws ResourceNotFoundException {
        Resource res;
        block3: {
            try {
                res = this.serializationSupport.getResourceSerializer().getResource(id);
                if (res != null) break block3;
                return 0;
            }
            catch (InvalidResourceReferenceException invalidResourceReferenceException) {
                return 0;
            }
        }
        return ((ResourceImpl)res).id;
    }

    public void ensureLoaded(ReadGraphImpl graph, int subject, int predicate) {
        if (subject < 0) {
            SessionImplSocket.loadVirtualStatements(this.virtualGraphServerSupport, graph, subject, predicate, g -> {});
        } else {
            Object cluster = this.clusterTable.checkedGetClusterByResourceKey(subject);
            if (cluster.isLoaded()) {
                if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject) && !SessionImplSocket.areVirtualStatementsLoaded(this.virtualGraphServerSupport, subject, predicate)) {
                    SessionImplSocket.loadVirtualStatements(this.virtualGraphServerSupport, graph, subject, predicate, g -> {});
                }
            } else {
                cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable((ClusterI)cluster, subject, predicate, graph){
                    private final /* synthetic */ ClusterI val$cluster;
                    private final /* synthetic */ int val$subject;
                    private final /* synthetic */ int val$predicate;
                    private final /* synthetic */ ReadGraphImpl val$graph;
                    {
                        this.val$cluster = clusterI;
                        this.val$subject = n;
                        this.val$predicate = n2;
                        this.val$graph = readGraphImpl;
                    }

                    @Override
                    public void run() {
                        if (this.val$cluster.hasVirtual() && QuerySupportImpl.this.virtualGraphServerSupport.virtuals.contains(this.val$subject) && !SessionImplSocket.areVirtualStatementsLoaded(QuerySupportImpl.this.virtualGraphServerSupport, this.val$subject, this.val$predicate)) {
                            SessionImplSocket.loadVirtualStatements(QuerySupportImpl.this.virtualGraphServerSupport, this.val$graph, this.val$subject, this.val$predicate, g -> {});
                        }
                    }
                });
            }
        }
    }

    public void ensureLoaded(ReadGraphImpl graph, int subject) {
        if (subject < 0) {
            SessionImplSocket.loadVirtualStatements(this.virtualGraphServerSupport, graph, subject, g -> {});
        } else {
            Object cluster = this.clusterTable.getClusterByResourceKey(subject);
            if (cluster.isLoaded()) {
                if (cluster.hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject) && !SessionImplSocket.areVirtualStatementsLoaded(this.virtualGraphServerSupport, subject)) {
                    SessionImplSocket.loadVirtualStatements(this.virtualGraphServerSupport, graph, subject, g -> {});
                }
            } else {
                cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable((ClusterI)cluster, subject, graph){
                    private final /* synthetic */ ClusterI val$cluster;
                    private final /* synthetic */ int val$subject;
                    private final /* synthetic */ ReadGraphImpl val$graph;
                    {
                        this.val$cluster = clusterI;
                        this.val$subject = n;
                        this.val$graph = readGraphImpl;
                    }

                    @Override
                    public void run() {
                        if (this.val$cluster.hasVirtual() && QuerySupportImpl.this.virtualGraphServerSupport.virtuals.contains(this.val$subject) && !SessionImplSocket.areVirtualStatementsLoaded(QuerySupportImpl.this.virtualGraphServerSupport, this.val$subject)) {
                            SessionImplSocket.loadVirtualStatements(QuerySupportImpl.this.virtualGraphServerSupport, this.val$graph, this.val$subject, g -> {});
                        }
                    }
                });
            }
        }
    }

    public boolean isLoaded(int subject) {
        Object cluster = this.clusterTable.getClusterByResourceKey(subject);
        return cluster.isLoaded();
    }

    public void ceased(int thread) {
        this.session.ceased(thread);
    }

    public Object getLock() {
        return this.session.requestManager;
    }

    public VirtualGraph getProvider(int subject, int predicate, int object) {
        ClusterImpl cluster;
        if (!(subject <= 0 || (cluster = (ClusterImpl)((Object)this.clusterTable.getClusterByResourceKey(subject))).hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject))) {
            return null;
        }
        for (TransientGraph g : this.virtualGraphServerSupport.providers) {
            int[] nArray = g.getObjects(subject, predicate);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (object == id) {
                    return g;
                }
                ++n2;
            }
        }
        return null;
    }

    public VirtualGraph getProvider(int subject, int predicate) {
        ClusterImpl cluster;
        if (!(subject <= 0 || (cluster = (ClusterImpl)((Object)this.clusterTable.getClusterByResourceKey(subject))).hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject))) {
            return null;
        }
        TransientGraph result = null;
        for (TransientGraph g : this.virtualGraphServerSupport.providers) {
            if (g.getObjects(subject, predicate).length <= 0) continue;
            if (result != null) {
                return null;
            }
            result = g;
        }
        return result;
    }

    public VirtualGraph getValueProvider(int subject) {
        ClusterImpl cluster;
        if (!(subject <= 0 || (cluster = (ClusterImpl)((Object)this.clusterTable.getClusterByResourceKey(subject))).hasVirtual() && this.virtualGraphServerSupport.virtuals.contains(subject))) {
            return null;
        }
        TransientGraph result = null;
        for (TransientGraph g : this.virtualGraphServerSupport.providers) {
            if (g.getValue(subject) == null) continue;
            if (result != null) {
                return null;
            }
            result = g;
        }
        return result;
    }

    public void exit(Throwable t) {
        this.state.close();
    }

    private void analyseProblem(ClusterI cluster) {
        if (cluster instanceof ClusterSmall) {
            try {
                ((ClusterSmall)cluster).check();
            }
            catch (DatabaseException e) {
                LOGGER.error("ClusterSmall.check failed", (Throwable)e);
            }
        }
    }
}

