/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.Operation;
import org.simantics.db.service.ExternalOperation;

public class OperationImpl
implements Operation {
    private final long id;
    private final long csid;
    private Operation combined;
    private final List<ExternalOperation> externals;

    OperationImpl(long id, long csid) {
        this(id, csid, null);
    }

    OperationImpl(long id, long csid, List<ExternalOperation> externals) {
        this.id = id;
        this.csid = csid;
        this.combined = null;
        this.externals = externals.isEmpty() ? null : externals;
    }

    public String toString() {
        return "Operation id=" + this.id + " cs=" + this.csid + ".";
    }

    public long getId() {
        return this.id;
    }

    public long getCSId() {
        return this.csid;
    }

    public void combine(Operation operation) {
        this.combined = operation;
    }

    public List<Operation> getOperations() {
        if (this.combined == null) {
            return Collections.singletonList(this);
        }
        ArrayList<Operation> result = new ArrayList<Operation>();
        OperationImpl current = this;
        while (current != null) {
            result.add(current);
            current = (OperationImpl)current.combined;
        }
        Collections.reverse(result);
        return result;
    }

    public Collection<ExternalOperation> getExternalOperations() {
        if (this.externals == null) {
            return Collections.emptyList();
        }
        return this.externals;
    }
}

