/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.db.IO;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSets {
    static final Logger LOGGER = LoggerFactory.getLogger(ClusterSets.class);
    private IO write;
    private final String databaseId;
    private final HashMap<Long, Long> clusterSets;
    private final HashMap<Long, Long> reverseMap;
    private int refCount;
    private boolean modified;

    public void setWriteDirectory(IO write) {
        this.write = write;
    }

    public ClusterSets(IO read, IO write, String databaseId) {
        try {
            this.databaseId = databaseId;
            this.write = write;
            PersistentDataBlob blob = null;
            try {
                byte[] mainStateValue = read.readBytes(0L, (int)read.length());
                ByteArrayInputStream bais = new ByteArrayInputStream(mainStateValue);
                blob = (PersistentDataBlob)Files.readFile((InputStream)bais, (Binding)PersistentDataBlob.BINDING);
                bais.close();
            }
            catch (IOException iOException) {
                blob = new PersistentDataBlob();
                blob.clusterSets = new HashMap();
                blob.reverseMap = new HashMap();
                this.doSave(read, blob);
            }
            this.clusterSets = blob.clusterSets;
            this.reverseMap = blob.reverseMap;
            this.modified = false;
        }
        catch (Exception exception) {
            throw new RuntimeDatabaseException("Failed to create ClusterSets.");
        }
    }

    public synchronized int inc() {
        return ++this.refCount;
    }

    public synchronized int dec() {
        return --this.refCount;
    }

    public void dispose() {
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeDatabaseException("Failed to save ClusterSets.");
        }
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void put(long resourceId, long clusterId) {
        this.clusterSets.put(resourceId, clusterId);
        this.reverseMap.put(clusterId, resourceId);
        this.modified = true;
    }

    public synchronized Long getClusterSet(Long clusterId) {
        return this.reverseMap.get(clusterId);
    }

    public void clear() {
        for (Long key : this.clusterSets.keySet()) {
            this.clusterSets.put(key, -1L);
        }
        this.touch();
    }

    public synchronized void touch() {
        this.modified = true;
    }

    private synchronized PersistentDataBlob doSave(IO io, PersistentDataBlob blob) throws IOException {
        byte[] bytes = blob.bytes();
        this.write.saveBytes(bytes, bytes.length, true);
        return blob;
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        PersistentDataBlob blob = new PersistentDataBlob();
        blob.clusterSets = this.clusterSets;
        blob.reverseMap = this.reverseMap;
        this.doSave(this.write, blob);
        this.modified = false;
    }

    public void validate(long[] ids) {
        TLongHashSet idSet = new TLongHashSet(ids);
        ArrayList<Long> clusterSetResourceIds = new ArrayList<Long>(this.clusterSets.keySet());
        for (long setResourceId : clusterSetResourceIds) {
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (!idSet.contains(setClusterId)) {
                this.clusterSets.remove(setResourceId);
                LOGGER.info("Remove cluster set mapping: cluster set has been removed " + setResourceId);
                continue;
            }
            long clusterId = this.clusterSets.get(setResourceId);
            if (clusterId == -1L || idSet.contains(clusterId)) continue;
            this.clusterSets.put(setResourceId, -1L);
            LOGGER.info("Reset cluster set mapping: active cluster set cluster has been removed " + setResourceId + " " + clusterId);
        }
        ArrayList<Long> setClusterIds = new ArrayList<Long>(this.reverseMap.keySet());
        for (Long clusterId : setClusterIds) {
            if (clusterId == -1L) continue;
            if (!idSet.contains(clusterId.longValue())) {
                this.reverseMap.remove(clusterId);
                LOGGER.info("Remove cluster set reverse mapping: cluster has been removed " + String.valueOf(clusterId));
                continue;
            }
            Long setResourceId = this.reverseMap.get(clusterId);
            long setClusterId = ClusterTraitsBase.getClusterIdFromResourceId((long)setResourceId);
            if (idSet.contains(setClusterId)) continue;
            this.reverseMap.remove(clusterId);
            LOGGER.info("Remove cluster set reverse mapping: cluster set cluster has been removed " + setClusterId);
        }
    }

    public static class PersistentDataBlob {
        public static final Binding BINDING = Bindings.getBindingUnchecked(PersistentDataBlob.class);
        public HashMap<Long, Long> clusterSets;
        public HashMap<Long, Long> reverseMap;

        public byte[] bytes() throws IOException {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BinaryMemory rf = new BinaryMemory(4096);){
                Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT).serialize((DataOutput)rf, (Object)MutableVariant.ofInstance((Object)this));
                return rf.toByteBuffer().array();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

