/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.Change;
import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.WriteState;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.SerialisationSupport;

public class ClusterBuilderImpl2
implements ClusterBuilder2 {
    private final ClusterSupport cs;
    private final SerialisationSupport ss;
    private final ClusterStream stream;
    private final SessionImplSocket.WriteOnlySupport support;
    private final ClusterImpl[] clusterArray;
    private boolean allowImmutables;
    byte[] buffer = new byte[65536];
    int bufferOffset = 0;
    int valueSubject = 0;
    int valueOffset = 0;

    ClusterBuilderImpl2(SessionImplSocket session, boolean allowImmutables) {
        WriteState<?> state = session.writeState;
        if (state != null) {
            WriteGraphImpl graph = state.getGraph();
            this.support = (SessionImplSocket.WriteOnlySupport)graph.writeSupport;
            this.stream = this.support.stream;
        } else {
            this.support = null;
            this.stream = null;
        }
        this.ss = session.getService(SerialisationSupport.class);
        this.clusterArray = session.clusterTable.getClusterArray();
        this.cs = session.getService(ClusterSupport.class);
        this.allowImmutables = allowImmutables;
    }

    ClusterBuilderImpl2(SessionImplSocket session) {
        this(session, false);
    }

    public void newCluster() throws DatabaseException {
        this.support.flushCluster();
    }

    public void selectCluster(long cluster) throws DatabaseException {
        this.support.selectCluster(cluster);
    }

    public void newCluster(int setHandle) throws DatabaseException {
        this.support.setDefaultClusterSet(this.resource(setHandle));
        this.support.flushCluster();
    }

    public void createClusterSet(int resource) throws DatabaseException {
        this.support.createClusterSet(null, this.resource(resource));
    }

    public int newResource() throws DatabaseException {
        Resource result = this.support.createResource(null);
        return this.handle(result);
    }

    public int newResource(int set) throws DatabaseException {
        Resource result = this.support.createResource(null, this.resource(set));
        return this.ss.getTransientId(result);
    }

    public int resource(Resource res) throws DatabaseException {
        ResourceImpl r = (ResourceImpl)res;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)r.id);
        ClusterImpl cluster = this.clusterArray[clusterKey];
        if (cluster.cc == null) {
            cluster.cc = new ClusterChange(this.stream, cluster);
        }
        return r.id;
    }

    public void addStatement(WriteOnlyGraph graph, int subject, int predicate, int object) throws DatabaseException {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)subject);
        ClusterImpl cluster = this.clusterArray[clusterKey];
        if (!cluster.isLoaded()) {
            cluster = (ClusterImpl)this.cs.getClusterByResourceKey(subject);
        }
        if (cluster.isWriteOnly()) {
            this.addStatement(cluster, subject, predicate, object);
        } else {
            WriteGraphImpl impl = (WriteGraphImpl)graph;
            if (!cluster.getImmutable() || this.allowImmutables) {
                impl.writeSupport.claim(graph.getProvider(), subject, predicate, object);
            }
        }
    }

    private void addStatement(ClusterImpl cluster, int resourceKey, int predicate, int object) {
        if (cluster.getImmutable()) {
            return;
        }
        Change change = cluster.change;
        change.addStatementIndex0(resourceKey, (byte)2);
        this.applyPredicate(cluster, predicate);
        this.applyObject(cluster, object);
        cluster.cc.addChange(change);
    }

    public void applyPredicate(ClusterImpl impl, int predicate) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)predicate);
        ClusterImpl cluster = this.clusterArray[clusterKey];
        impl.change.addStatementIndex1(predicate, cluster.clusterUID, (byte)0, impl.foreignLookup);
    }

    public void applyObject(ClusterImpl impl, int object) {
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)object);
        ClusterImpl cluster = this.clusterArray[clusterKey];
        impl.change.addStatementIndex2(object, cluster.clusterUID, (byte)0, impl.foreignLookup);
    }

    public Resource resource(int key) {
        try {
            return this.ss.getResource(key);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public int handle(Resource r) {
        return ((ResourceImpl)r).id;
    }

    public void beginValue(int subject) {
        this.valueSubject = subject;
        this.bufferOffset = 0;
        this.valueOffset = 0;
    }

    public void appendValue(int byteValue) throws DatabaseException {
        this.buffer[this.bufferOffset++] = (byte)byteValue;
        if (this.bufferOffset == 65536) {
            int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)this.valueSubject);
            ClusterImpl cluster = this.clusterArray[clusterKey];
            cluster.modiValueEx(this.valueSubject, this.valueOffset, 65536, this.buffer, 0, this.cs);
            this.bufferOffset = 0;
            this.valueOffset += 65536;
        }
    }

    public void endValue() throws DatabaseException {
        if (this.bufferOffset > 0) {
            int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)this.valueSubject);
            ClusterImpl cluster = this.clusterArray[clusterKey];
            if (this.valueOffset == 0) {
                if (cluster.isWriteOnly()) {
                    cluster.cc.setValue((short)(this.valueSubject & 0xFFF), this.buffer, this.bufferOffset);
                } else {
                    this.support.claimValue(null, this.valueSubject, this.buffer, this.bufferOffset);
                }
            } else {
                cluster.modiValueEx(this.valueSubject, this.valueOffset, this.bufferOffset, this.buffer, 0, this.cs);
            }
        }
    }
}

