/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI.Procedure;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;

public class ArgumentTable extends Table<long[]> {
    ArgumentTable(TableSizeListener sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, longs);
    }
	int createArgument(long a1) {
		int tableIndex = createNewElement(1);
	    int realIndex = checkIndexAndGetRealIndex(tableIndex, 1);
		long[] table = getTable();
		table[realIndex] = a1;
		return tableIndex;
	}
	int createArgument(long a1, long a2) {
		int tableIndex = createNewElement(2);
	    int realIndex = checkIndexAndGetRealIndex(tableIndex, 2);
		long[] table = getTable();
		table[realIndex] = a1;
		table[++realIndex] = a2;
		return tableIndex;
	}
	int createArgument(long a1, long a2, long a3, long a4, long a5) {
		int tableIndex = createNewElement(5);
	    int realIndex = checkIndexAndGetRealIndex(tableIndex, 5);
		long[] table = getTable();
		table[realIndex] = a1;
		table[++realIndex] = a2;
		table[++realIndex] = a3;
		table[++realIndex] = a4;
		table[++realIndex] = a5;
		return tableIndex;
	}
	long[] getArguments(int argIndex, int size) {
	    int realIndex = checkIndexAndGetRealIndex(argIndex, size);
		long[] table = getTable();
		long[] dest = new long[size];
		System.arraycopy(table, realIndex, dest, 0, size);
		return dest;
	}
    @Override
    public <Context> boolean foreach(int setIndex, Procedure procedure, Context context,
            ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}
