package fi.vtt.simantics.procore.internal;

import org.simantics.db.MonitorContext;
import org.simantics.db.MonitorHandler;
import org.simantics.db.SessionVariables;
import org.simantics.db.service.SessionMonitorSupport;

public class SessionMonitorSupportImpl implements SessionMonitorSupport {
	
	final private SessionImplSocket session;
	
	SessionMonitorSupportImpl(SessionImplSocket session) {
		this.session = session;
	}
    
    @Override
    public synchronized MonitorContext registerMonitor(MonitorHandler h) {
        assert h != null;

        MonitorContext ctx = new MonitorContext() {
            @Override
            public int getInteger(String key) {
                if (SessionVariables.QUEUED_READS.equals(key)) {
                    return session.state.getReadCount();
                } else if (SessionVariables.QUEUED_WRITES.equals(key)) {
                    return session.state.getWriteCount();
                }
                return -1;
            }

            @Override
            public String getString(String key) {
                return null;
            }
        };
        session.monitorContexts.map(ctx, h);

        MonitorHandler[] newHandlers = new MonitorHandler[session.monitorHandlers.length + 1];
        System.arraycopy(session.monitorHandlers, 0, newHandlers, 0, session.monitorHandlers.length);
        newHandlers[session.monitorHandlers.length] = h;
        session.monitorHandlers = newHandlers;

        return ctx;
    }

    @Override
    public synchronized void unregisterMonitor(MonitorContext ctx) {
        MonitorHandler h = session.monitorContexts.getRight(ctx);
        if (h == null)
            return;
        int i = 0;
        for (i = 0; i < session.monitorHandlers.length; i++) {
            if (h.equals(session.monitorHandlers[i]))
                break;
        }
        if (i < session.monitorHandlers.length) {
            MonitorHandler[] newHandlers = new MonitorHandler[session.monitorHandlers.length - 1];
            System.arraycopy(session.monitorHandlers, 0, newHandlers, 0, i);
            System.arraycopy(session.monitorHandlers, i + 1, newHandlers, i, session.monitorHandlers.length - i - 1);
        }
    }
    
}
