/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.concurrent.TimeUnit;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.variable.NodeCache;
import org.simantics.db.layer0.variable.NodeStructureRequest;
import org.simantics.db.layer0.variable.NodeValueRequest;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableNodeReadRunnable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ExternalRead;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NoValueException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSupport<Node> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeSupport.class);
    public final NodeManager<Node> manager;
    public final NodeCache<Node, Variant> valueCache;
    public final NodeCache<Node, Variables.NodeStructure> structureCache;

    public NodeSupport(NodeManager<Node> manager) {
        this(manager, 1L, TimeUnit.SECONDS);
    }

    public NodeSupport(NodeManager<Node> manager, long defaultExpirationTime, TimeUnit expirationTimeUnit) {
        if (manager == null) {
            throw new NullPointerException("null NodeManager");
        }
        long ns = expirationTimeUnit.toNanos(defaultExpirationTime);
        this.manager = manager;
        this.valueCache = new NodeCache(ns);
        this.structureCache = new NodeCache(ns);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.valueCache.hashCode();
        result = 31 * result + this.structureCache.hashCode();
        result = 31 * result + this.manager.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeSupport other = (NodeSupport)obj;
        return this.valueCache.equals(other.valueCache) && this.structureCache.equals(other.structureCache) && this.manager.equals(other.manager);
    }

    public Variant requestNodeValue(ReadGraph graph, VariableNode<?> node, Binding binding) throws DatabaseException {
        Variant value = (Variant)graph.syncRequest((ExternalRead)new NodeValueRequest(node, binding));
        if (Variables.PENDING_NODE_VALUE == value && ((Boolean)graph.getHintValue("sync")).booleanValue()) {
            ValueGetter getter = new ValueGetter(node, binding);
            try {
                node.support.manager.getRealm().syncExec((Runnable)getter);
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while getting node value", (Throwable)e);
                throw new InvalidVariableException("External data access error " + String.valueOf(node), e);
            }
            if (getter.exception != null) {
                throw new MissingVariableValueException("No value for node " + String.valueOf(node), getter.exception);
            }
            return getter.result;
        }
        return value;
    }

    public void refreshCache(Node node) throws NodeManagerException {
        VariableNode variableNode = new VariableNode(this, node);
        Variables.NodeStructure ns = NodeStructureRequest.get(variableNode);
        this.structureCache.put(node, ns);
        try {
            Variant value = this.manager.getValue(node);
            this.valueCache.put(node, value);
        }
        catch (NoValueException noValueException) {
            this.valueCache.remove(node);
        }
    }

    public void invalidateCache(Node node) throws NodeManagerException {
        this.structureCache.remove(node);
        this.valueCache.remove(node);
    }

    public void dispose() {
        this.valueCache.dispose();
        this.structureCache.dispose();
    }

    private static class ValueGetter
    implements VariableNodeReadRunnable {
        final VariableNode n;
        final Binding binding;
        Variant result;
        Exception exception;

        public ValueGetter(VariableNode n, Binding binding) {
            this.n = n;
            this.binding = binding;
        }

        @Override
        public void run() {
            try {
                Object value;
                this.result = this.binding != null ? (Variables.PENDING_NODE_VALUE == (value = this.n.support.manager.getValue(this.n.node, this.binding)) ? Variables.PENDING_NODE_VALUE : new Variant(this.binding, value)) : this.n.support.manager.getValue(this.n.node);
            }
            catch (NodeManagerException e) {
                this.exception = e;
            }
            catch (Exception e) {
                LOGGER.error("Error while getting node value", (Throwable)e);
                this.exception = e;
            }
        }
    }
}

