/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.service.ExternalOperation;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class ExternalSetValue
implements ExternalOperation {
    private final NodeManager manager;
    private final Object node;
    private final Object oldValue;
    private final Object newValue;
    private final Binding binding;

    public ExternalSetValue(NodeManager manager, Object node, Object oldValue, Object newValue, Binding binding) {
        this.manager = manager;
        this.node = node;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.binding = binding;
    }

    public void undo() {
        try {
            this.manager.setValue(this.node, this.oldValue, this.binding);
        }
        catch (BindingException | NodeManagerException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public void redo() {
        try {
            this.manager.setValue(this.node, this.newValue, this.binding);
        }
        catch (BindingException | NodeManagerException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public boolean isDisposed() {
        return false;
    }
}

