/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityInstances;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.NullWriter;
import org.simantics.db.layer0.request.PossibleResource;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;

public class InstanceOfMigrationStep
implements MigrationStep {
    private final Migration[] migrations;

    public InstanceOfMigrationStep(String fromUri, String toUri) {
        this.migrations = new Migration[]{new Migration(fromUri, toUri)};
    }

    public InstanceOfMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        ArrayList<Migration> ms = new ArrayList<Migration>();
        List uris = ListUtils.toList((ReadGraph)graph, (Resource)step);
        int size = uris.size() & 0xFFFFFFFE;
        int i = 0;
        while (i < size) {
            String from = (String)graph.getPossibleValue((Resource)uris.get(i), (Binding)Bindings.STRING);
            String to = (String)graph.getPossibleValue((Resource)uris.get(i + 1), (Binding)Bindings.STRING);
            if (from != null && to != null) {
                ms.add(new Migration(from, to));
            }
            i += 2;
        }
        this.migrations = ms.toArray(new Migration[ms.size()]);
    }

    @Override
    public void applyTo(final IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Collection roots = (Collection)state.getProperty("currentRootResources");
        if (roots.isEmpty()) {
            return;
        }
        final PrintWriter log = MigrationUtils.getProperty(state, "messageLogWriter", NullWriter.PRINT_INSTANCE);
        session.sync((WriteInterface)new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                InstanceOfMigrationStep.this.migrateInstances(monitor, graph, roots, log);
            }
        });
    }

    private void migrateInstances(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        Migration[] migrationArray = this.migrations;
        int n = this.migrations.length;
        int n2 = 0;
        while (n2 < n) {
            Migration m = migrationArray[n2];
            this.migrateInstances(monitor, graph, new RMigration((RequestProcessor)graph, m), roots, log);
            ++n2;
        }
    }

    private void migrateInstances(IProgressMonitor monitor, WriteGraph graph, RMigration rm, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        log.println("## InstanceOf Migration ##");
        log.println("* From: `" + rm.m.fromUri + "`");
        log.println("* To: `" + rm.m.toUri + "`");
        if (rm.isValid()) {
            for (Resource root : roots) {
                InstanceOfMigrationStep.migrateInstances(monitor, graph, root, rm, log);
            }
        } else {
            log.println("\nSkipping migration as invalid.\n");
        }
    }

    private static void migrateInstances(IProgressMonitor monitor, WriteGraph graph, Resource root, RMigration migration, PrintWriter log) throws DatabaseException {
        log.println("### Migrating root `" + NameUtils.getSafeName((ReadGraph)graph, (Resource)root) + "` ###");
        String rootUri = NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)root);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource instance : InstanceOfMigrationStep.instancesOf((ReadGraph)graph, root, migration.from)) {
            if (!graph.hasStatement(instance, L0.InstanceOf, migration.from)) continue;
            graph.deny(instance, L0.InstanceOf, null, migration.from);
            graph.claim(instance, L0.InstanceOf, null, migration.to);
            log.println("* `" + InstanceOfMigrationStep.relativeUri((ReadGraph)graph, rootUri, instance) + "`");
        }
    }

    private static List<Resource> instancesOf(ReadGraph graph, Resource root, Resource type) throws DatabaseException {
        return (List)graph.syncRequest((Read)new EntityInstances.QueryIndex(root, type, ""), (Listener)TransientCacheListener.instance());
    }

    private static String relativeUri(ReadGraph graph, String rootUri, Resource r) throws DatabaseException {
        String uri = graph.getPossibleURI(r);
        return uri != null ? uri.substring(rootUri.length()) : NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)r);
    }

    private static class Migration {
        public final String fromUri;
        public final String toUri;

        public Migration(String from, String to) {
            this.fromUri = from;
            this.toUri = to;
        }

        public String toString() {
            return this.fromUri + " -> " + this.toUri;
        }
    }

    private static class RMigration {
        public final Migration m;
        public final Resource from;
        public final Resource to;

        public RMigration(RequestProcessor processor, Migration m) throws DatabaseException {
            this.m = m;
            this.from = (Resource)processor.syncRequest((Read)new PossibleResource(m.fromUri));
            this.to = (Resource)processor.syncRequest((Read)new PossibleResource(m.toUri));
        }

        public boolean isValid() {
            return this.from != null && this.to != null;
        }
    }
}

