/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;

public abstract class AbstractRemover
implements Remover {
    protected final Resource resource;

    public AbstractRemover(Resource resource) {
        this.resource = resource;
    }

    protected String consultPossibleCanRemove(ReadGraph graph, Resource r, Map<Object, Object> aux) throws DatabaseException {
        Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
        if (remover != null) {
            return remover.canRemove(graph, aux);
        }
        return null;
    }

    protected boolean consultPossibleRemover(WriteGraph graph, Resource r) throws DatabaseException {
        Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
        if (remover != null) {
            remover.remove(graph);
            return true;
        }
        return false;
    }

    @Override
    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        return null;
    }
}

