package org.simantics.db.layer0.variable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLVariableMap implements VariableMap {

	private Function1<Variable, List<Variable>> getVariablesF;

	public SCLVariableMap(Function1<Variable, List<Variable>> getVariablesF) {
		this.getVariablesF = getVariablesF;
	}

	private List<Variable> apply(ReadGraph graph, Variable context) throws DatabaseException {
		SCLContext sclContext = SCLContext.getCurrent();
		Object oldGraph = sclContext.get("graph");
		try {
			sclContext.put("graph", graph);
			return getVariablesF.apply(context);
		} catch (Throwable t) {
			throw new DatabaseException(t);
		} finally {
			sclContext.put("graph", oldGraph);
		}
	}

	@Override
	public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
		for(Variable variable : apply(graph, context)) {
			if(variable.getName(graph).equals(name))
				return variable;
		}
		return null;
	}

	@Override
	public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map)
			throws DatabaseException {
		for(Variable variable : apply(graph, context)) {
			if(map == null)
				map = new HashMap<>();
			map.put(variable.getName(graph), variable);
		}
		return map;
	}

	@Override
	public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification,
			Map<String, Variable> map) throws DatabaseException {
		for(Variable variable : apply(graph, context)) {
			if(variable.getClassifications(graph).contains(classification)) {
				if(map == null)
					map = new HashMap<>();
				map.put(variable.getName(graph), variable);
			}
		}
		return map;
	}

}
