package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PropertyMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI.RVIPart;
import org.simantics.db.layer0.variable.RVI.StringRVIPart;
import org.simantics.db.layer0.variable.Variables.Role;

public abstract class AbstractPropertyVariable extends AbstractVariable {

    final protected static Binding datatype_binding = Bindings.getBindingUnchecked(Datatype.class);

    public abstract Resource getPropertyResource(ReadGraph graph) throws DatabaseException;
    public abstract Resource getContainerResource(ReadGraph graph) throws DatabaseException;
    public abstract Datatype getDatatype(ReadGraph graph) throws DatabaseException;
    public abstract Variable getPredicate(ReadGraph graph) throws DatabaseException;

    public AbstractPropertyVariable() {
    	this(null);
    }

    public AbstractPropertyVariable(VariableNode node) {
    	super(node);
    }
    
    public String getLabel(ReadGraph graph) throws DatabaseException {

    	/*
    	 * This should work but doesn't. REPRESENTS incorrectly returns the predicate resource.
    	 *     
    	 * 
    	 */
    	
    	Object value = getPossibleValue(graph);
    	return value == null ? "<no value>" : value.toString(); 
    	
    }
    
    
    public String getUnit(ReadGraph graph) throws DatabaseException {
        Datatype dt = getPossibleDatatype(graph);
        if (dt == null)
            return "";
        else if (dt instanceof NumberType) {
        	String result = ((NumberType) dt).getUnit(); 
            return result != null ? result : "";
        } else if (dt instanceof ArrayType) {
            ArrayType at = (ArrayType) dt;
            Datatype cdt = at.componentType();
            if (cdt instanceof NumberType) {
            	String result = ((NumberType) cdt).getUnit(); 
                return result != null ? result : "";
            }
        }
        return null;
    }

    @Override
    public Role getRole(ReadGraph graph) throws DatabaseException {
        return Role.PROPERTY;
    }
    
    @Override
    public Collection<Variable> getChildren(ReadGraph graph)
            throws DatabaseException {
        return Collections.emptyList();
    }
    
    @Override
    public Variable getPossibleChild(ReadGraph graph, String name)
            throws DatabaseException {
        return null;
    }
    
    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name)
            throws DatabaseException {
        return null;
    }
    
    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph,
            Map<String, Variable> properties) throws DatabaseException {
    	return properties;
    }

    /**
     * @see org.simantics.db.layer0.variable.AbstractVariable#getRepresents(org.simantics.db.ReadGraph)
     * 
     * FIXME: change this method to throw exceptions if representation is
     *      not found and leave the current logic to
     *      {@link #getPossibleRepresents(ReadGraph)}.
     */
    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        Variable parent = getParent(graph);
        if(parent == null)
            return null;
        Resource parentRepresents = parent.getPossibleRepresents(graph);
        if (parentRepresents == null)
            return null;
        Resource predicate = graph.syncRequest(new PropertyMapOfResource(parentRepresents))
                .get(getName(graph));
        if (predicate == null)
            return null;
        return graph.getPossibleObject(parentRepresents, predicate);
    }

    @Override
    public Resource getPossibleRepresents(ReadGraph graph) throws DatabaseException {
        Variable parent = getParent(graph);
        if(parent == null)
            return null;
        Resource parentRepresents = parent.getPossibleRepresents(graph);
        if (parentRepresents == null)
            return null;
        Resource predicate = graph.syncRequest(new PropertyMapOfResource(parentRepresents))
                .get(getName(graph));
        if (predicate == null)
            return null;
        return graph.getPossibleObject(parentRepresents, predicate);
    }

    @Override
    public Variable getPossibleExtraProperty(ReadGraph graph, String name) throws DatabaseException {
        /*if(Variables.DATATYPE.equals(name)) {
            Object value = getPossibleDatatype(graph);
            if (value != null)
                return new ConstantPropertyVariable(this, name, value, datatype_binding);
        } else if(Variables.UNIT.equals(name)) {
            Object value = getUnit(graph);
            return new ConstantPropertyVariable(this, name, value, Bindings.STRING);
        } else  if(Variables.PREDICATE.equals(name)) {
            Object value = getPossiblePredicate(graph);
            if (value != null)
                return new ConstantPropertyVariable(this, name, value, null);
        } */
        return null;
    }
    
    @Override
    public void collectExtraProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
//        addProperty(properties, Variables.PREDICATE, getPossiblePredicate(graph), null);
//        Datatype dt = getPossibleDatatype(graph);
//        if(dt != null)
//            addProperty(properties, Variables.DATATYPE, dt, datatype_binding);
        //addProperty(properties, Variables.UNIT, getUnit(graph), Bindings.STRING);
    }
    
    
    @Override
    public RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
    	return new StringRVIPart(Role.PROPERTY, getName(graph));
    }
    
    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
    	return Collections.emptySet();
    }
    
}
