/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;

public abstract class VariableRead<T> implements Read<T>, ReadInterface<T> {

    final protected Variable variable;

    @Override
    public int hashCode() {
        return variable.hashCode();
    }
    
    protected Class<?> clazz() {
    	return getClass();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!clazz().isInstance(object))
            return false;
        VariableRead<?> r = (VariableRead<?>) object;
        return variable.equals(r.variable);
    }

    public VariableRead(Variable variable) {
    	if(variable == null) throw new IllegalArgumentException("Null variable.");
        this.variable = variable;
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Procedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Listener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public T request(RequestProcessor processor) throws DatabaseException {
    	return processor.syncRequest(this);
    }
    
    @Override
    public String toString() {
    	return getClass().getSimpleName() + "|" + variable; 
    }
    
}
