package org.simantics.db.layer0.genericrelation;

import gnu.trove.set.hash.THashSet;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.simantics.db.Resource;

class DependenciesListenerStore {
	
	private final Map<Resource,Set<Runnable>> listeners = new HashMap<Resource,Set<Runnable>>();

	public synchronized void addListener(Resource model, Runnable listener) {
		Set<Runnable> list = listeners.get(model);
		if(list == null) {
			list = new THashSet<Runnable>();
			listeners.put(model, list);
		}
		list.add(listener);
		if (DependenciesRelation.DEBUG_LISTENERS) {
			System.out.println("DependenciesRelation.addListener(" + listener + "), " + listeners.size() + " total listeners");
			new Exception("DependenciesRelation.addListener(" + listener + ")").printStackTrace(System.out);
		}
	}

	public synchronized void removeListener(Resource model, Runnable listener) {
		Set<Runnable> list = listeners.get(model);
		if(list == null) return;
		list.remove(listener);
		if (DependenciesRelation.DEBUG_LISTENERS) {
			System.out.println("DependenciesRelation.removeListener(" + listener + "), " + listeners.size() + " total listeners");
			new Exception("DependenciesRelation.removeListener(" + listener + ")").printStackTrace(System.out);
		}
	}

	public synchronized void fireListeners(Resource model) {
		Set<Runnable> list = listeners.get(model);
		if(list == null) return;
		for (Runnable r : list) {
			r.run();
		}
	}

}