/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.util.RemoverUtil;

/**
 * A simple {@link Remover} implementation for removing a resource and its specified related objects using the {@link EntityRemover} logic.
 * 
 * @author Tuukka Lehtonen
 */
public class RelatedObjectRemover extends AbstractRemover {

    Resource[] relations;

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI) throws DatabaseException {
        super(component);
        relations = new Resource[] { graph.getResource(relationURI) };
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI, String relationURI2) throws DatabaseException {
        this(graph, component, new String[] { relationURI, relationURI2 });
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String relationURI, String relationURI2, String relationURI3) throws DatabaseException {
        this(graph, component, new String[] { relationURI, relationURI2, relationURI3 });
    }

    public RelatedObjectRemover(ReadGraph graph, Resource component, String... relationURIs) throws DatabaseException {
        super(component);
        if (relationURIs.length == 0) {
            relations = Resource.NONE;
        } else {
            relations = new Resource[relationURIs.length];
            for (int i = 0; i < relationURIs.length; ++i)
                relations[i] = graph.getResource(relationURIs[i]);
        }
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        Collection<Resource> objects = new ArrayList<Resource>();
        for (Resource relation : relations) {
            for (Resource object : graph.getObjects(resource, relation)) {
                if (object.equals(resource))
                    continue;
                objects.add(object);
            }
        }

        // Remove self first to prevent later actions for returning to it.
        EntityRemover.remove(graph, resource);

        // Finally, remove related matter.
        for (Resource object : objects)
            RemoverUtil.remove(graph, object);
    }

}
